/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.util;

import com.github.kongchen.swagger.docgen.reader.JaxrsReader;
import com.github.kongchen.swagger.docgen.util.TypeWithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TypeExtracter {
    private static final AccessibleObjectGetter<Field> FIELD_GETTER = new AccessibleObjectGetter<Field>(){

        public Field[] get(Class<?> clazz) {
            return clazz.getDeclaredFields();
        }
    };
    private static final AccessibleObjectGetter<Method> METHOD_GETTER = new AccessibleObjectGetter<Method>(){

        public Method[] get(Class<?> clazz) {
            return clazz.getDeclaredMethods();
        }
    };
    private static final AccessibleObjectGetter<Constructor<?>> CONSTRUCTOR_GETTER = new AccessibleObjectGetter<Constructor<?>>(){

        public Constructor<?>[] get(Class<?> clazz) {
            return clazz.getDeclaredConstructors();
        }
    };

    public Collection<TypeWithAnnotations> extractTypes(Class<?> cls) {
        ArrayList<TypeWithAnnotations> typesWithAnnotations = new ArrayList<TypeWithAnnotations>();
        typesWithAnnotations.addAll(this.getPropertyTypes(cls));
        typesWithAnnotations.addAll(this.getMethodParameterTypes(cls));
        typesWithAnnotations.addAll(this.getConstructorParameterTypes(cls));
        return typesWithAnnotations;
    }

    private Collection<TypeWithAnnotations> getPropertyTypes(Class<?> clazz) {
        ArrayList<TypeWithAnnotations> typesWithAnnotations = new ArrayList<TypeWithAnnotations>();
        for (Field field : this.getDeclaredAndInheritedMembers(clazz, FIELD_GETTER)) {
            Type type = field.getGenericType();
            List<Annotation> annotations = Arrays.asList(field.getAnnotations());
            typesWithAnnotations.add(new TypeWithAnnotations(type, annotations));
        }
        return typesWithAnnotations;
    }

    private Collection<TypeWithAnnotations> getMethodParameterTypes(Class<?> clazz) {
        ArrayList<TypeWithAnnotations> typesWithAnnotations = new ArrayList<TypeWithAnnotations>();
        for (Method method : this.getDeclaredAndInheritedMembers(clazz, METHOD_GETTER)) {
            Type[] parameterTypes = method.getGenericParameterTypes();
            if (parameterTypes.length != 1 || method.getReturnType() != Void.TYPE) continue;
            Type type = parameterTypes[0];
            List<Annotation> annotations = Arrays.asList(JaxrsReader.findParamAnnotations(method)[0]);
            typesWithAnnotations.add(new TypeWithAnnotations(type, annotations));
        }
        return typesWithAnnotations;
    }

    private Collection<TypeWithAnnotations> getConstructorParameterTypes(Class<?> clazz) {
        ArrayList<TypeWithAnnotations> typesWithAnnotations = new ArrayList<TypeWithAnnotations>();
        for (Constructor<?> constructor : this.getDeclaredAndInheritedMembers(clazz, CONSTRUCTOR_GETTER)) {
            Type[] parameterTypes = constructor.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type type = parameterTypes[i];
                List<Annotation> annotations = Arrays.asList(parameterAnnotations[i]);
                typesWithAnnotations.add(new TypeWithAnnotations(type, annotations));
            }
        }
        return typesWithAnnotations;
    }

    private <T extends AccessibleObject> List<T> getDeclaredAndInheritedMembers(Class<?> clazz, AccessibleObjectGetter<? extends T> getter) {
        ArrayList<AccessibleObject> fields = new ArrayList<AccessibleObject>();
        for (Class<?> inspectedClass = clazz; inspectedClass != null; inspectedClass = inspectedClass.getSuperclass()) {
            fields.addAll(Arrays.asList(getter.get(inspectedClass)));
        }
        return fields;
    }

    private static interface AccessibleObjectGetter<T extends AccessibleObject> {
        public T[] get(Class<?> var1);
    }
}

