/*
 * Decompiled with CFR 0.152.
 */
package com.naturalness;

import com.naturalness.Event;
import com.naturalness.NGram;
import com.naturalness.NGramSuccessorModel;
import com.naturalness.Sequence;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaturalnessModel<T> {
    private final int DEPTH_DEFAULT = 3;
    private final double PROBA_OF_UNKNOWN_DEFAULT = 1.0E-6;
    private int depth = 3;
    private double probaOfUnknown = 1.0E-6;
    private Map<NGram<T>, NGramSuccessorModel> ngramMap = new HashMap<NGram<T>, NGramSuccessorModel>();

    public NaturalnessModel() {
    }

    public NaturalnessModel(int depth, double probaOfUnknown) {
        this();
        this.depth = depth;
        this.probaOfUnknown = probaOfUnknown;
    }

    public int getDepth() {
        return this.depth;
    }

    public double getProbaOfUnknown() {
        return this.probaOfUnknown;
    }

    public double crossEntropy(Sequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("sequence cannot be null");
        }
        List eventList = sequence.getEventList();
        if (eventList.size() == 0) {
            return this.probaOfUnknown;
        }
        double probabilitySum = 0.0;
        for (int i = 0; i < eventList.size(); ++i) {
            Event currentEvent = eventList.get(i);
            NGram currentNgram = sequence.getNgram(i, this.depth);
            double modelProba = this.getProbability(currentNgram, currentEvent);
            double proba = modelProba == 0.0 ? this.probaOfUnknown : modelProba * (1.0 - this.probaOfUnknown);
            probabilitySum += Math.log(proba) / Math.log(2.0);
        }
        return -(probabilitySum / (double)eventList.size());
    }

    public double getProbability(NGram ngram, Event event) {
        if (ngram == null || event == null) {
            return 0.0;
        }
        if (!this.ngramMap.containsKey(ngram)) {
            return 0.0;
        }
        return this.ngramMap.get(ngram).getProbability(event);
    }

    public final void learn(Event<T> ... events) {
        this.learn(Arrays.asList(events));
    }

    public final void learn(List<Event<T>> eventList) {
        this.learn(new Sequence<T>(eventList));
    }

    public void learn(Sequence<T> sequence) {
        List<Event<T>> eventList = sequence.getEventList();
        for (int i = 0; i < eventList.size(); ++i) {
            NGram<T> ngram = sequence.getNgram(i, this.depth);
            if (!this.ngramMap.containsKey(ngram)) {
                this.ngramMap.put(ngram, new NGramSuccessorModel());
            }
            NGramSuccessorModel ngramSuccessor = this.ngramMap.get(ngram);
            ngramSuccessor.learn(eventList.get(i));
        }
    }

    public int size() {
        int size = 0;
        for (NGramSuccessorModel successorModel : this.ngramMap.values()) {
            size += successorModel.size();
        }
        return size;
    }

    public int occurence() {
        int occurence = 0;
        for (NGramSuccessorModel successorModel : this.ngramMap.values()) {
            occurence += successorModel.occurence();
        }
        return occurence;
    }
}

