/*
 * Decompiled with CFR 0.152.
 */
package com.naturalness;

import com.naturalness.Event;
import com.naturalness.NGram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Sequence<T> {
    private List<Event<T>> eventList;

    public Sequence(Event<T> ... events) {
        this(Arrays.asList(events));
    }

    public Sequence(List<Event<T>> eventList) {
        this.eventList = new ArrayList<Event<T>>(eventList);
    }

    public List<Event<T>> getEventList() {
        return new ArrayList<Event<T>>(this.eventList);
    }

    public void append(Event<T> event) {
        this.eventList.add(event);
    }

    public NGram<T> getNgram(int before, int size) {
        ArrayList ngramEventList = new ArrayList();
        if (before > 0) {
            int from;
            for (int i = from = Math.max(0, before - size); i < before; ++i) {
                ngramEventList.add(this.eventList.get(i));
            }
        }
        return new NGram(ngramEventList);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Sequence)) {
            return false;
        }
        Sequence otherSequence = (Sequence)other;
        if (otherSequence.eventList.size() != this.eventList.size()) {
            return false;
        }
        for (int i = 0; i < otherSequence.eventList.size(); ++i) {
            Event<T> thisEvent;
            Event<T> otherEvent = otherSequence.eventList.get(i);
            if (otherEvent.equals(thisEvent = this.eventList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.eventList.hashCode();
    }
}

