/*
 * Decompiled with CFR 0.152.
 */
package com.naturalness;

import com.naturalness.NaturalnessModel;
import com.naturalness.Ranking;
import com.naturalness.Sequence;
import java.util.ArrayList;
import java.util.List;

public class SequenceSuite<T> {
    private final int DEPTH_DEFAULT = 3;
    private final double PROBA_OF_UNKNOWN_DEFAULT = 1.0E-6;
    private int depth;
    private double probaOfUnknown;
    private List<Sequence<T>> sequenceList;

    public SequenceSuite(List<Sequence<T>> sequenceList) {
        if (sequenceList == null) {
            throw new IllegalArgumentException("SequenceSuite new with null");
        }
        this.depth = 3;
        this.probaOfUnknown = 1.0E-6;
        this.sequenceList = new ArrayList<Sequence<T>>(sequenceList);
    }

    public SequenceSuite(List<Sequence<T>> sequenceList, int depth, double probaOfUnknown) {
        this(sequenceList);
        this.depth = depth;
        this.probaOfUnknown = probaOfUnknown;
    }

    public Ranking getMoreNatural() {
        if (this.sequenceList.size() == 0) {
            throw new IllegalStateException("SequenceSuite is empty");
        }
        double minEntropy = -Math.log(this.probaOfUnknown) / Math.log(2.0);
        Sequence minSequence = this.sequenceList.get(0);
        if (this.sequenceList.size() == 1) {
            return new Ranking<T>(this.sequenceList.get(0), minEntropy);
        }
        for (int i = 0; i < this.sequenceList.size(); ++i) {
            NaturalnessModel model = new NaturalnessModel(this.depth, this.probaOfUnknown);
            ArrayList<Sequence<T>> suiteCopy = new ArrayList<Sequence<T>>(this.sequenceList);
            Sequence current = (Sequence)suiteCopy.remove(i);
            for (Sequence sequence : suiteCopy) {
                model.learn(sequence);
            }
            double currentCrossEntropy = model.crossEntropy(current);
            if (!(currentCrossEntropy < minEntropy)) continue;
            minEntropy = currentCrossEntropy;
            minSequence = current;
        }
        return new Ranking<T>(minSequence, minEntropy);
    }

    public List<Ranking> rank() {
        if (this.sequenceList.size() == 0) {
            return new ArrayList<Ranking>();
        }
        ArrayList<Ranking> rankingList = new ArrayList<Ranking>();
        Ranking moreNatural = this.getMoreNatural();
        rankingList.add(moreNatural);
        ArrayList<Sequence<T>> suiteCopy = new ArrayList<Sequence<T>>(this.sequenceList);
        suiteCopy.remove(moreNatural.getSequence());
        SequenceSuite<T> other = new SequenceSuite<T>(suiteCopy);
        rankingList.addAll(other.rank());
        return rankingList;
    }
}

