/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.web3j.codegen.SolidityFunctionWrapper;
import org.web3j.mavenplugin.Contract;
import org.web3j.mavenplugin.JsonParser;
import org.web3j.mavenplugin.SourceDestination;
import org.web3j.mavenplugin.solidity.CompilerResult;
import org.web3j.mavenplugin.solidity.SolidityCompiler;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.core.methods.response.AbiDefinition;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class JavaClassGeneratorMojo
extends AbstractMojo {
    private static final String DEFAULT_SOLIDITY_INCLUDE = "**/*.sol";
    private static final String DEFAULT_ABI_INCLUDE = "**/*.json";
    private static final String DEFAULT_PACKAGE = "org.web3j.model";
    private static final String DEFAULT_SOURCE_DESTINATION = "src/main/java";
    private static final String DEFAULT_SOLIDITY_SOURCES = "src/main/resources";
    private static final String DEFAULT_ABI_SOURCES = "src/main/resources";
    private static final String DEFAULT_OUTPUT_FORMAT = "java";
    @Parameter(property="packageName", defaultValue="org.web3j.model")
    protected String packageName;
    @Parameter(property="sourceDestination", defaultValue="src/main/java")
    protected String sourceDestination;
    @Parameter(property="outputDirectory")
    protected SourceDestination outputDirectory = new SourceDestination();
    @Parameter(property="soliditySourceFiles")
    protected FileSet soliditySourceFiles = new FileSet();
    @Parameter(property="abiSourceFiles")
    protected FileSet abiSourceFiles = new FileSet();
    @Parameter(property="contract")
    protected Contract contract;
    @Parameter(property="nativeJavaType", defaultValue="true")
    protected boolean nativeJavaType;
    @Parameter(property="pathPrefixes")
    protected String[] pathPrefixes = new String[0];
    @Parameter(property="outputFormat", defaultValue="java")
    protected String outputFormat;
    @Parameter(property="outputJavaParentContractClassName")
    protected String outputJavaParentContractClassName;

    private Path createPath(String destinationPath) throws IOException {
        Path path = Paths.get(destinationPath, this.packageName);
        if (!path.toFile().exists()) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    private Map<String, Map<String, Object>> extractContracts(String result) throws MojoExecutionException {
        JsonParser jsonParser = new JsonParser();
        Map<String, Object> json = jsonParser.parseJson(result);
        Map contracts = (Map)json.get("contracts");
        if (contracts == null) {
            this.getLog().warn((CharSequence)"no contracts found");
            return null;
        }
        HashMap<String, String> contractRemap = new HashMap<String, String>();
        HashSet contractsKeys = new HashSet(contracts.keySet());
        for (String contractFilename : contractsKeys) {
            Map compilationTarget;
            Map contractMetadata = (Map)contracts.get(contractFilename);
            Object metadata = contractMetadata.get("metadata");
            if (metadata == null || metadata instanceof String && ((String)metadata).length() == 0) {
                contracts.remove(contractFilename);
                continue;
            }
            this.getLog().debug((CharSequence)("metadata:" + metadata));
            Map<String, Object> metadataJson = jsonParser.parseJson(metadata.toString());
            Object settingsMap = metadataJson.get("settings");
            if (settingsMap != null && (compilationTarget = (Map)((Map)settingsMap).get("compilationTarget")) != null) {
                for (Map.Entry entry : compilationTarget.entrySet()) {
                    String value = (String)entry.getValue();
                    contractRemap.put(contractFilename, value);
                }
            }
            Map compiledContract = (Map)contracts.remove(contractFilename);
            String contractName = (String)contractRemap.get(contractFilename);
            contracts.put(contractName, compiledContract);
        }
        return contracts;
    }

    private void generatedJavaClass(Map<String, Object> results, String contractName) throws IOException, ClassNotFoundException {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)DEFAULT_OUTPUT_FORMAT)) {
            return;
        }
        List<AbiDefinition> functionDefinitions = this.loadContractDefinition(results.get(SolidityCompiler.Options.ABI.getName()).toString());
        this.generatedJavaClass(contractName, functionDefinitions, (String)results.get(SolidityCompiler.Options.BIN.getName()));
    }

    private void generatedJavaClass(String contractName, List<AbiDefinition> functionDefinitions, String bin) throws IOException, ClassNotFoundException {
        int addressLength = 20;
        boolean primitiveTypes = false;
        if (functionDefinitions.isEmpty()) {
            this.getLog().warn((CharSequence)"Unable to parse input ABI file");
            return;
        }
        Class<org.web3j.tx.Contract> contractClass = this.outputJavaParentContractClassName == null ? org.web3j.tx.Contract.class : Class.forName(this.outputJavaParentContractClassName);
        new SolidityFunctionWrapper(this.nativeJavaType, primitiveTypes, false, addressLength).generateJavaFiles(contractClass, contractName, bin, functionDefinitions, StringUtils.defaultString((String)this.outputDirectory.getJava(), (String)this.sourceDestination), this.packageName, null);
    }

    private void processSolidityFile(Collection<String> files) throws MojoExecutionException {
        String result = this.parseSoliditySources(files);
        this.processResult(result, "\tNo Solidity \u0441ontract found in files '" + files + "'");
    }

    public void processAbiFile(Collection<String> fileNames) throws IOException, ClassNotFoundException {
        for (String fileName : fileNames) {
            File file = Paths.get(this.abiSourceFiles.getDirectory(), fileName).toFile();
            this.generatedJavaClass(FilenameUtils.removeExtension((String)file.getName()), FileUtils.readFileToString((File)file));
        }
    }

    private void generatedJavaClass(String contractName, String fileContent) throws IOException, ClassNotFoundException {
        this.generatedJavaClass(contractName, this.loadContractDefinition(fileContent), "Bin file was not provided");
    }

    public void execute() throws MojoExecutionException {
        this.processSolidityFiles();
        this.processAbiFiles();
    }

    private void processSolidityFiles() throws MojoExecutionException {
        String[] files;
        if (this.soliditySourceFiles.getDirectory() == null) {
            this.getLog().info((CharSequence)"No Solidity directory specified, using default directory [src/main/resources]");
            this.soliditySourceFiles.setDirectory("src/main/resources");
        }
        if (this.soliditySourceFiles.getIncludes().isEmpty()) {
            this.getLog().info((CharSequence)"No Solidity contracts specified, using the default [**/*.sol]");
            this.soliditySourceFiles.setIncludes(Collections.singletonList(DEFAULT_SOLIDITY_INCLUDE));
        }
        if ((files = new FileSetManager().getIncludedFiles(this.soliditySourceFiles)) != null) {
            this.processSolidityFile(Stream.of(files).filter(f -> {
                this.getLog().info((CharSequence)("Solidity: adding to process '" + f + "'"));
                return true;
            }).collect(Collectors.toList()));
        }
    }

    private void processAbiFiles() throws MojoExecutionException {
        String[] abiFiles;
        if (this.abiSourceFiles.getDirectory() == null) {
            this.getLog().info((CharSequence)"No abiSourceFiles directory specified, using default directory [src/main/resources]");
            this.abiSourceFiles.setDirectory("src/main/resources");
        }
        if (this.abiSourceFiles.getIncludes().isEmpty()) {
            this.getLog().info((CharSequence)"No abiSourceFiles contracts specified, using the default [**/*.json]");
            this.abiSourceFiles.setIncludes(Collections.singletonList(DEFAULT_ABI_INCLUDE));
        }
        if ((abiFiles = new FileSetManager().getIncludedFiles(this.abiSourceFiles)) != null) {
            try {
                this.processAbiFile(Stream.of(abiFiles).peek(it -> this.getLog().info((CharSequence)("Abi: adding to process '" + it + "'"))).collect(Collectors.toList()));
            }
            catch (IOException | ClassNotFoundException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Error during abi source files processing", e);
            }
        }
    }

    private void generatedAbi(Map<String, Object> contractResult, String contractName) {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)"abi")) {
            return;
        }
        String abiJson = contractResult.get(SolidityCompiler.Options.ABI.getName()).toString();
        try {
            String filename = contractName + ".json";
            Path path = this.createPath(StringUtils.defaultString((String)this.outputDirectory.getAbi(), (String)this.sourceDestination));
            Files.write(Paths.get(path.toString(), filename), abiJson.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not build abi file for contract '" + contractName + "'"), (Throwable)e);
        }
    }

    private void generatedBin(Map<String, Object> contractResult, String contractName) {
        if (!StringUtils.containsIgnoreCase((CharSequence)this.outputFormat, (CharSequence)"bin")) {
            return;
        }
        String binJson = contractResult.get(SolidityCompiler.Options.BIN.getName()).toString();
        try {
            String filename = contractName + ".bin";
            Path path = this.createPath(StringUtils.defaultString((String)this.outputDirectory.getBin(), (String)this.sourceDestination));
            Files.write(Paths.get(path.toString(), filename), binJson.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not build bin file for contract '" + contractName + "'"), (Throwable)e);
        }
    }

    protected List<AbiDefinition> loadContractDefinition(String abiFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(abiFile, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private String parseSoliditySources(Collection<String> includedFiles) throws MojoExecutionException {
        if (includedFiles.isEmpty()) {
            return "{}";
        }
        CompilerResult result = SolidityCompiler.getInstance(this.getLog()).compileSrc(this.soliditySourceFiles.getDirectory(), includedFiles, this.pathPrefixes, SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN, SolidityCompiler.Options.METADATA);
        if (result.isFailed()) {
            throw new MojoExecutionException("Could not compile Solidity files\n" + result.errors);
        }
        this.getLog().debug((CharSequence)("\t\tResult:\t" + result.output));
        if (result.errors.contains("Warning:")) {
            this.getLog().info((CharSequence)("\tCompile Warning:\n" + result.errors));
        } else {
            this.getLog().debug((CharSequence)("\t\tError: \t" + result.errors));
        }
        return result.output;
    }

    private void processResult(String result, String warnMsg) throws MojoExecutionException {
        Map<String, Map<String, Object>> contracts = this.extractContracts(result);
        if (contracts == null) {
            this.getLog().warn((CharSequence)warnMsg);
            return;
        }
        for (Map.Entry<String, Map<String, Object>> entry : contracts.entrySet()) {
            String contractName = entry.getKey();
            if (this.isFiltered(contractName)) {
                this.getLog().debug((CharSequence)("\tContract '" + contractName + "' is filtered"));
                continue;
            }
            try {
                Map<String, Object> contractResult = entry.getValue();
                this.generatedJavaClass(contractResult, contractName);
                this.generatedAbi(contractResult, contractName);
                this.generatedBin(contractResult, contractName);
                this.getLog().info((CharSequence)("\tBuilt Class for contract '" + contractName + "'"));
            }
            catch (IOException | ClassNotFoundException ioException) {
                this.getLog().error((CharSequence)("Could not build java class for contract '" + contractName + "'"), (Throwable)ioException);
            }
        }
    }

    private boolean isFiltered(String contractName) {
        if (this.contract == null) {
            return false;
        }
        if (this.contract.getExcludes() != null && !this.contract.getExcludes().isEmpty()) {
            return this.contract.getExcludes().contains(contractName);
        }
        if (this.contract.getIncludes() == null || this.contract.getIncludes().isEmpty()) {
            return false;
        }
        return !this.contract.getIncludes().contains(contractName);
    }
}

