/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin.solidity;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.web3j.mavenplugin.solidity.CompilerResult;
import org.web3j.sokt.SolcInstance;
import org.web3j.sokt.SolidityFile;

public class SolidityCompiler {
    private Log LOG;
    private static SolidityCompiler INSTANCE;
    private String usedSolCVersion;

    private SolidityCompiler(Log log) {
        this.LOG = log;
    }

    public static SolidityCompiler getInstance(Log log) {
        if (INSTANCE == null) {
            INSTANCE = new SolidityCompiler(log);
        }
        return INSTANCE;
    }

    public CompilerResult compileSrc(String rootDirectory, Collection<String> sources, String[] pathPrefixes, Options ... options) {
        String output;
        String error;
        boolean success;
        block2: {
            success = false;
            try {
                Process process = this.getSolcProcessFromSokt(rootDirectory, sources, pathPrefixes, options);
                ParallelReader errorReader = new ParallelReader(process.getErrorStream());
                ParallelReader outputReader = new ParallelReader(process.getInputStream());
                errorReader.start();
                outputReader.start();
                success = process.waitFor() == 0;
                error = errorReader.getContent();
                output = outputReader.getContent();
            }
            catch (IOException | InterruptedException e) {
                StringWriter errorWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(errorWriter));
                error = errorWriter.toString();
                output = "";
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        return new CompilerResult(error, output, success);
    }

    private Process getSolcProcessFromSokt(String rootDirectory, Collection<String> sources, String[] pathPrefixes, Options[] options) throws IOException {
        SolidityFile solidityFile = new SolidityFile(Paths.get(rootDirectory, sources.iterator().next()).toFile().getAbsolutePath());
        SolcInstance instance = solidityFile.getCompilerInstance(".web3j", true);
        if (!instance.installed()) {
            instance.install();
        }
        this.usedSolCVersion = instance.getSolcRelease().getVersion();
        List<String> commandParts = this.prepareCommandOptions(instance.getSolcFile().getAbsolutePath(), rootDirectory, sources, pathPrefixes, options);
        Process process = Runtime.getRuntime().exec(commandParts.toArray(new String[commandParts.size()]));
        return process;
    }

    private Map<String, String> getAbsolutePathPrefixes(String rootDirectory, String[] pathPrefixes) {
        return Stream.of(pathPrefixes).map(pathPrefix -> this.replaceMakePathPrefixAbsolute(rootDirectory, (String)pathPrefix)).collect(Collectors.toMap(p -> p[0], p -> p[1]));
    }

    private String prepareAllowPath(String rootDirectory, String[] pathPrefixes) {
        return Stream.concat(Stream.of(rootDirectory).map(x$0 -> this.toAbsolutePath((String)x$0, new String[0])), this.getAbsolutePathPrefixes(rootDirectory, pathPrefixes).values().stream()).collect(Collectors.joining(","));
    }

    private List<String> prepareCommandOptions(String canonicalSolCPath, String rootDirectory, Collection<String> sources, String[] pathPrefixes, Options ... options) {
        String outputFormats = Arrays.stream(options).map(Options::toString).collect(Collectors.joining(","));
        String allowedPaths = this.prepareAllowPath(rootDirectory, pathPrefixes);
        List dependencyPath = this.getAbsolutePathPrefixes(rootDirectory, pathPrefixes).entrySet().stream().map(entry1 -> (String)entry1.getKey() + "=" + (String)entry1.getValue()).collect(Collectors.toList());
        List sourceFiles = sources.stream().map(source -> this.toAbsolutePath(rootDirectory, (String)source)).collect(Collectors.toList());
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(canonicalSolCPath);
        commandParts.add("--optimize");
        commandParts.add("--combined-json");
        commandParts.add(outputFormats);
        commandParts.add("--allow-paths");
        commandParts.add(allowedPaths);
        commandParts.addAll(dependencyPath);
        commandParts.addAll(sourceFiles);
        return commandParts;
    }

    private String toAbsolutePath(String baseDirectory, String ... subDirectories) {
        return Paths.get(baseDirectory, subDirectories).normalize().toFile().getAbsolutePath();
    }

    String[] replaceMakePathPrefixAbsolute(String baseDirectory, String pathPrefix) {
        String[] prefixAndPath = pathPrefix.split("=", 2);
        prefixAndPath[1] = this.toAbsolutePath(baseDirectory, prefixAndPath[1]);
        return prefixAndPath;
    }

    public String getUsedSolCVersion() {
        return this.usedSolCVersion;
    }

    private static class ParallelReader
    extends Thread {
        private InputStream stream;
        private String content;

        ParallelReader(InputStream stream) {
            this.stream = stream;
        }

        public String getContent() {
            return this.getContent(true);
        }

        public synchronized String getContent(boolean waitForComplete) {
            if (waitForComplete) {
                while (this.stream != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
            }
            return this.content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(this.stream));){
                this.content = buffer.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                ParallelReader parallelReader = this;
                synchronized (parallelReader) {
                    this.stream = null;
                    this.notifyAll();
                }
            }
        }
    }

    public static enum Options {
        BIN("bin"),
        ABI("abi"),
        METADATA("metadata");

        private final String name;

        private Options(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

