/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.bean.info;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.info.BeanInformationException;
import org.meanbean.bean.info.PropertyDescriptorPropertyInformation;
import org.meanbean.bean.info.PropertyInformation;
import org.meanbean.util.ValidationHelper;
import org.meanbean.util.reflect.ReflectionAccessor;

class JavaBeanInformation
implements BeanInformation {
    private final Class<?> beanClass;
    private final BeanInfo beanInfo;
    private final Map<String, PropertyInformation> properties = new ConcurrentHashMap<String, PropertyInformation>();

    JavaBeanInformation(Class<?> beanClass) throws IllegalArgumentException, BeanInformationException {
        ValidationHelper.ensureExists("beanClass", "gather JavaBean information", beanClass);
        this.beanClass = beanClass;
        try {
            this.beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            throw new BeanInformationException("Failed to acquire information about beanClass [" + beanClass + "].", e);
        }
        this.initialize();
    }

    private void initialize() {
        Map<String, Method> fluentWriteMethods = this.findFluentWriteMethods(this.beanInfo);
        for (PropertyDescriptor propertyDescriptor : this.beanInfo.getPropertyDescriptors()) {
            if ("class".equals(propertyDescriptor.getName())) continue;
            PropertyDescriptorPropertyInformation propertyInformation = new PropertyDescriptorPropertyInformation(propertyDescriptor);
            Method fluentWriteMethod = fluentWriteMethods.get(propertyDescriptor.getName());
            if (!propertyInformation.isWritable() && fluentWriteMethod != null) {
                propertyInformation.setWriteMethodOverride(fluentWriteMethod);
            }
            if (propertyInformation.isReadableWritable()) {
                this.makeAccessible(propertyInformation.getReadMethod());
                this.makeAccessible(propertyInformation.getWriteMethod());
            }
            this.properties.put(propertyInformation.getName(), propertyInformation);
        }
    }

    private Map<String, Method> findFluentWriteMethods(BeanInfo beanInfo) {
        List<Method> methods = this.findCandidateWriteMethods(beanInfo.getMethodDescriptors());
        HashMap<String, Method> fluentMethods = new HashMap<String, Method>();
        for (Method method : methods) {
            String propertyName = method.getName().substring(3);
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            fluentMethods.put(propertyName, method);
        }
        return fluentMethods;
    }

    private List<Method> findCandidateWriteMethods(MethodDescriptor ... methodDescriptors) {
        ArrayList<Method> matches = new ArrayList<Method>();
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            Method method = methodDescriptor.getMethod();
            if (!JavaBeanInformation.isCandidateWriteMethod(method)) continue;
            matches.add(method);
        }
        matches.sort((m1, m2) -> m2.toString().compareTo(m1.toString()));
        return matches;
    }

    private static boolean isCandidateWriteMethod(Method method) {
        String methodName = method.getName();
        int nParams = method.getParameterCount();
        return methodName.length() > 3 && methodName.startsWith("set") && Modifier.isPublic(method.getModifiers()) && !Void.TYPE.isAssignableFrom(method.getReturnType()) && nParams == 1;
    }

    private void makeAccessible(Method method) {
        if (!method.isAccessible()) {
            ReflectionAccessor.getInstance().makeAccessible(method);
        }
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Collection<PropertyInformation> getProperties() {
        return this.properties.values();
    }
}

