/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.bean.info;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.meanbean.bean.info.PropertyInformation;

class PropertyDescriptorPropertyInformation
implements PropertyInformation {
    private final String name;
    private final PropertyDescriptor propertyDescriptor;
    private Method writeMethodOverride;

    PropertyDescriptorPropertyInformation(PropertyDescriptor propertyDescriptor) {
        this.name = propertyDescriptor.getName();
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadable() {
        return this.getReadMethod() != null;
    }

    @Override
    public boolean isWritable() {
        return this.getWriteMethod() != null;
    }

    @Override
    public boolean isReadableWritable() {
        return this.isReadable() && this.isWritable();
    }

    @Override
    public Method getReadMethod() {
        return this.propertyDescriptor.getReadMethod();
    }

    @Override
    public Method getWriteMethod() {
        if (this.writeMethodOverride != null) {
            return this.writeMethodOverride;
        }
        return this.propertyDescriptor.getWriteMethod();
    }

    public Method getWriteMethodOverride() {
        return this.writeMethodOverride;
    }

    public void setWriteMethodOverride(Method writeMethodOverride) {
        this.writeMethodOverride = writeMethodOverride;
    }

    @Override
    public Type getReadMethodReturnType() {
        if (this.isReadable()) {
            return this.getReadMethod().getGenericReturnType();
        }
        return null;
    }

    @Override
    public Type getWriteMethodParameterType() throws IllegalArgumentException {
        Method writeMethod = this.getWriteMethod();
        if (writeMethod != null) {
            Type[] parameterTypes = writeMethod.getGenericParameterTypes();
            return parameterTypes[0];
        }
        return null;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("PropertyDescriptorPropertyInformation[");
        str.append("name=").append(this.name).append(",");
        str.append("isReadable=").append(this.isReadable()).append(",");
        str.append("readMethod=").append(this.getReadMethod()).append(",");
        str.append("isWritable=").append(this.isWritable()).append(",");
        str.append("writeMethod=").append(this.getWriteMethod()).append(",");
        str.append("isReadableWritable=").append(this.isReadableWritable());
        str.append("]");
        return str.toString();
    }
}

