/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.factories.equivalent;

import java.util.Map;
import org.meanbean.bean.info.BeanInformation;
import org.meanbean.bean.util.BasicBeanPopulator;
import org.meanbean.bean.util.BeanPopulator;
import org.meanbean.bean.util.BeanPropertyValuesFactory;
import org.meanbean.factories.BasicNewObjectInstanceFactory;
import org.meanbean.factories.beans.BeanCreationException;
import org.meanbean.factories.util.FactoryLookupStrategy;
import org.meanbean.lang.EquivalentFactory;
import org.meanbean.lang.Factory;
import org.meanbean.test.Configuration;
import org.meanbean.util.ValidationHelper;

public class EquivalentPopulatedBeanFactory
implements EquivalentFactory<Object> {
    private final BeanInformation beanInformation;
    private Map<String, Object> propertyValues;
    private final BeanPropertyValuesFactory beanPropertyValuesFactory;
    private final BeanPopulator beanPopulator = new BasicBeanPopulator();

    public EquivalentPopulatedBeanFactory(BeanInformation beanInformation, FactoryLookupStrategy factoryLookupStrategy, Configuration configuration) throws IllegalArgumentException {
        ValidationHelper.ensureExists("beanInformation", "construct Factory", beanInformation);
        ValidationHelper.ensureExists("factoryLookupStrategy", "construct Factory", factoryLookupStrategy);
        this.beanInformation = beanInformation;
        this.beanPropertyValuesFactory = new BeanPropertyValuesFactory(beanInformation, factoryLookupStrategy, configuration);
    }

    @Override
    public Object create() throws BeanCreationException {
        if (this.propertyValues == null) {
            this.propertyValues = this.beanPropertyValuesFactory.create();
        }
        Factory<Object> beanFactory = BasicNewObjectInstanceFactory.findBeanFactory(this.beanInformation.getBeanClass());
        Object result = beanFactory.create();
        this.beanPopulator.populate(result, this.beanInformation, this.propertyValues);
        return result;
    }
}

