/*
 * Decompiled with CFR 0.152.
 */
package org.meanbean.test;

import org.meanbean.lang.EquivalentFactory;
import org.meanbean.util.AssertionUtils;
import org.meanbean.util.ValidationHelper;

class EqualsMethodContractVerifier {
    private static final Object NULL = null;

    EqualsMethodContractVerifier() {
    }

    public void verifyEqualsMethod(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals", factory);
        this.verifyEqualsReflexive(factory);
        this.verifyEqualsSymmetric(factory);
        this.verifyEqualsTransitive(factory);
        this.verifyEqualsConsistent(factory);
        this.verifyEqualsNull(factory);
        this.verifyEqualsDifferentType(factory);
    }

    public void verifyEqualsReflexive(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals reflexive item", factory);
        Object x = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals reflexive item", x);
        if (!x.equals(x)) {
            AssertionUtils.fail("equals is not reflexive.");
        }
    }

    public void verifyEqualsSymmetric(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals symmetric item", factory);
        Object x = factory.create();
        Object y = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals symmetric item", x);
        ValidationHelper.ensureExists("factory-created object", "test equals symmetric item", y);
        if (!x.equals(y)) {
            String message = "Cannot test equals symmetric item if factory does not create logically equivalent objects. Does factory not create logically equivalent objects, or do objects not override equals?";
            throw new IllegalArgumentException(message);
        }
        if (x.equals(y) && !y.equals(x)) {
            AssertionUtils.fail("equals is not symmetric.");
        }
    }

    public void verifyEqualsTransitive(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals transitive item", factory);
        Object x = factory.create();
        Object y = factory.create();
        Object z = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals transitive item", x);
        ValidationHelper.ensureExists("factory-created object", "test equals transitive item", y);
        ValidationHelper.ensureExists("factory-created object", "test equals transitive item", z);
        if (!x.equals(y) || !y.equals(z)) {
            String message = "Cannot test equals transitive item if factory does not create logically equivalent objects.";
            throw new IllegalArgumentException(message);
        }
        if (x.equals(y) && y.equals(z) && !x.equals(z)) {
            AssertionUtils.fail("equals is not transitive.");
        }
    }

    public void verifyEqualsConsistent(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals consistent item", factory);
        Object x = factory.create();
        Object y = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals consistent item", x);
        ValidationHelper.ensureExists("factory-created object", "test equals consistent item", y);
        for (int idx = 0; idx < 100; ++idx) {
            if (x.equals(y)) continue;
            AssertionUtils.fail("equals is not consistent on invocation [" + idx + "].");
        }
    }

    public void verifyEqualsNull(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals null item", factory);
        Object x = factory.create();
        ValidationHelper.ensureExists("factory-created object", "test equals null item", x);
        if (x.equals(NULL)) {
            AssertionUtils.fail("equals is incorrect with respect to null comparison.");
        }
    }

    public void verifyEqualsDifferentType(EquivalentFactory<?> factory) throws IllegalArgumentException, AssertionError {
        ValidationHelper.ensureExists("factory", "test equals for different types", factory);
        Object x = factory.create();
        Object differentObject = new Object();
        ValidationHelper.ensureExists("factory-created object", "test equals for different types", x);
        if (x.equals(differentObject)) {
            AssertionUtils.fail("equals should not find objects of different type to be equal.");
        }
    }
}

