/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.iterables;

import com.thebuzzmedia.exiftool.commons.iterables.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Collections {
    private Collections() {
    }

    public static <T> boolean isEmpty(Collection<T> values) {
        return values == null || values.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> values) {
        return !Collections.isEmpty(values);
    }

    public static <T> int size(Collection<T> values) {
        return values == null ? 0 : values.size();
    }

    public static <T> Collection<T> toCollection(Iterable<T> iterables) {
        if (iterables == null) {
            return new ArrayList(0);
        }
        if (iterables instanceof Collection) {
            return (Collection)iterables;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T value : iterables) {
            list.add(value);
        }
        return list;
    }

    public static <T> String join(Collection<T> values, String separator) {
        if (Collections.isEmpty(values)) {
            return "";
        }
        Iterator<T> it = values.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(separator).append(it.next());
        }
        return sb.toString();
    }

    public static <T, U> List<U> map(Collection<T> inputs, Mapper<T, U> mapper) {
        ArrayList<U> outputs = new ArrayList<U>(inputs.size());
        for (T input : inputs) {
            U output = mapper.map(input);
            outputs.add(output);
        }
        return outputs;
    }

    public static <T> void addAll(Collection<T> collection, Iterable<T> iterable) {
        if (iterable == null || collection == null) {
            return;
        }
        for (T value : iterable) {
            collection.add(value);
        }
    }
}

