/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core;

import com.thebuzzmedia.exiftool.ExifToolOptions;
import com.thebuzzmedia.exiftool.Format;
import com.thebuzzmedia.exiftool.commons.lang.Strings;
import com.thebuzzmedia.exiftool.commons.lang.ToStringBuilder;
import com.thebuzzmedia.exiftool.core.StandardFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class StandardOptions
implements ExifToolOptions {
    private final Format format;
    private final boolean ignoreMinorErrors;
    private final String coordFormat;
    private final String dateFormat;
    private final Charset charset;
    private final String password;
    private final boolean escapeHtml;
    private final boolean escapeXml;
    private final List<String> modules;
    private final String lang;
    private final boolean duplicates;
    private final boolean extractEmbedded;
    private final OverwriteMode overwriteOriginal;

    public static Builder builder() {
        return new Builder();
    }

    private StandardOptions(Format format, boolean ignoreMinorErrors, String coordFormat, String dateFormat, Charset charset, String password, Collection<String> modules, boolean escapeHtml, boolean escapeXml, String lang, boolean duplicates, boolean extractEmbedded, OverwriteMode overwriteMode) {
        this.format = format;
        this.ignoreMinorErrors = ignoreMinorErrors;
        this.coordFormat = coordFormat;
        this.dateFormat = dateFormat;
        this.charset = charset;
        this.password = password;
        this.modules = Collections.unmodifiableList(new ArrayList<String>(modules));
        this.escapeHtml = escapeHtml;
        this.escapeXml = escapeXml;
        this.lang = lang;
        this.extractEmbedded = extractEmbedded;
        this.duplicates = duplicates;
        this.overwriteOriginal = overwriteMode;
    }

    @Override
    public Iterable<String> serialize() {
        String overwrite;
        ArrayList<String> arguments = new ArrayList<String>(30);
        if (this.format != null) {
            arguments.addAll(this.format.getArgs());
        }
        if (this.ignoreMinorErrors) {
            arguments.add("-m");
        }
        if (Strings.isNotEmpty(this.dateFormat)) {
            arguments.add("-dateFormat");
            arguments.add(this.dateFormat);
        }
        if (Strings.isNotEmpty(this.coordFormat)) {
            arguments.add("-coordFormat");
            arguments.add(this.coordFormat);
        }
        if (this.charset != null) {
            arguments.add("-charset");
            arguments.add(this.charset.displayName());
        }
        if (Strings.isNotEmpty(this.password)) {
            arguments.add("-password");
            arguments.add(this.password);
        }
        if (com.thebuzzmedia.exiftool.commons.iterables.Collections.isNotEmpty(this.modules)) {
            for (String module : this.modules) {
                arguments.add("-use");
                arguments.add(module);
            }
        }
        if (this.escapeHtml) {
            arguments.add("-E");
        }
        if (this.escapeXml) {
            arguments.add("-ex");
        }
        if (Strings.isNotEmpty(this.lang)) {
            arguments.add("-lang");
            arguments.add(this.lang);
        }
        if (this.duplicates) {
            arguments.add("-duplicates");
        }
        if (this.extractEmbedded) {
            arguments.add("-extractEmbedded");
        }
        String string = overwrite = this.overwriteOriginal == null ? null : this.overwriteOriginal.arg;
        if (Strings.isNotEmpty(overwrite)) {
            arguments.add(overwrite);
        }
        return arguments;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isIgnoreMinorErrors() {
        return this.ignoreMinorErrors;
    }

    public String getCoordFormat() {
        return this.coordFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getModules() {
        return this.modules;
    }

    public boolean isEscapeHtml() {
        return this.escapeHtml;
    }

    public boolean isEscapeXml() {
        return this.escapeXml;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isDuplicates() {
        return this.duplicates;
    }

    public boolean isExtractEmbedded() {
        return this.extractEmbedded;
    }

    public boolean isOverwriteOriginal() {
        return this.overwriteOriginal == OverwriteMode.COPY;
    }

    public boolean isOverwriteOriginalInPlace() {
        return this.overwriteOriginal == OverwriteMode.IN_PLACE;
    }

    public Builder toBuilder() {
        return new Builder().withFormat(this.format).withIgnoreMinorErrors(this.ignoreMinorErrors).withCoordFormat(this.coordFormat).withDateFormat(this.dateFormat).withCharset(this.charset).withPassword(this.password).useModules(this.modules).withEscapeHtml(this.escapeHtml).withEscapeXml(this.escapeXml).withLang(this.lang).withDuplicates(this.duplicates).withExtractEmbedded(this.extractEmbedded).withOverwiteMode(this.overwriteOriginal);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StandardOptions) {
            StandardOptions opts = (StandardOptions)o;
            return Objects.equals(this.format, opts.format) && Objects.equals(this.ignoreMinorErrors, opts.ignoreMinorErrors) && Objects.equals(this.coordFormat, opts.coordFormat) && Objects.equals(this.dateFormat, opts.dateFormat) && Objects.equals(this.charset, opts.charset) && Objects.equals(this.password, opts.password) && Objects.equals(this.modules, opts.modules) && Objects.equals(this.escapeHtml, opts.escapeHtml) && Objects.equals(this.escapeXml, opts.escapeXml) && Objects.equals(this.lang, opts.lang) && Objects.equals(this.duplicates, opts.duplicates) && Objects.equals(this.extractEmbedded, opts.extractEmbedded) && Objects.equals((Object)this.overwriteOriginal, (Object)opts.overwriteOriginal);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.ignoreMinorErrors, this.coordFormat, this.dateFormat, this.charset, this.password, this.modules, this.escapeHtml, this.escapeXml, this.lang, this.duplicates, this.extractEmbedded, this.overwriteOriginal});
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("format", this.format).append("ignoreMinorErrors", this.ignoreMinorErrors).append("coordFormat", this.coordFormat).append("dateFormat", this.dateFormat).append("charset", this.charset).append("password", this.password).append("modules", this.modules).append("escapeHtml", this.escapeHtml).append("escapeXml", this.escapeXml).append("lang", this.lang).append("duplicates", this.duplicates).append("extractEmbedded", this.extractEmbedded).append("overwriteOriginal", (Object)this.overwriteOriginal).build();
    }

    private static enum OverwriteMode {
        NONE(null),
        COPY("-overwrite_original"),
        IN_PLACE("-overwrite_original_in_place");

        private final String arg;

        private OverwriteMode(String arg) {
            this.arg = arg;
        }
    }

    public static class Builder {
        private Format format = StandardFormat.HUMAN_READABLE;
        private boolean ignoreMinorErrors = false;
        private String coordFormat = null;
        private String dateFormat = null;
        private Charset charset = null;
        private String password = null;
        private boolean escapeHtml = false;
        private boolean escapeXml = false;
        private final Set<String> modules = new LinkedHashSet<String>();
        private String lang = null;
        private boolean duplicates = false;
        private boolean extractEmbedded = false;
        private OverwriteMode overwriteOriginal = OverwriteMode.NONE;

        private Builder() {
        }

        public Builder withFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder withIgnoreMinorErrors(boolean ignoreMinorErrors) {
            this.ignoreMinorErrors = ignoreMinorErrors;
            return this;
        }

        public Builder withCoordFormat(String coordFormat) {
            this.coordFormat = coordFormat;
            return this;
        }

        public Builder withDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder useModules(String module, String ... others) {
            ArrayList<String> modules = new ArrayList<String>(1 + others.length);
            modules.add(module);
            Collections.addAll(modules, others);
            return this.useModules(modules);
        }

        public Builder useModules(Collection<String> modules) {
            this.modules.addAll(modules);
            return this;
        }

        public Builder withEscapeHtml(boolean escapeHtml) {
            this.escapeHtml = escapeHtml;
            return this;
        }

        public Builder withEscapeXml(boolean escapeXml) {
            this.escapeXml = escapeXml;
            return this;
        }

        public Builder withNumericFormat() {
            this.format = StandardFormat.NUMERIC;
            return this;
        }

        public Builder withHumanReadableFormat() {
            this.format = StandardFormat.HUMAN_READABLE;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withDuplicates(boolean duplicates) {
            this.duplicates = duplicates;
            return this;
        }

        public Builder withExtractEmbedded(boolean extractEmbedded) {
            this.extractEmbedded = extractEmbedded;
            return this;
        }

        public Builder doNotOverwiteOriginal() {
            return this.withOverwiteMode(OverwriteMode.NONE);
        }

        public Builder withOverwiteOriginal() {
            return this.withOverwiteMode(OverwriteMode.COPY);
        }

        public Builder withOverwiteOriginalInPlace() {
            return this.withOverwiteMode(OverwriteMode.IN_PLACE);
        }

        private Builder withOverwiteMode(OverwriteMode mode) {
            this.overwriteOriginal = mode;
            return this;
        }

        public StandardOptions build() {
            return new StandardOptions(this.format, this.ignoreMinorErrors, this.coordFormat, this.dateFormat, this.charset, this.password, this.modules, this.escapeHtml, this.escapeXml, this.lang, this.duplicates, this.extractEmbedded, this.overwriteOriginal);
        }

        public Format getFormat() {
            return this.format;
        }

        public boolean isIgnoreMinorErrors() {
            return this.ignoreMinorErrors;
        }

        public String getCoordFormat() {
            return this.coordFormat;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isEscapeHtml() {
            return this.escapeHtml;
        }

        public boolean isEscapeXml() {
            return this.escapeXml;
        }

        public Set<String> getModules() {
            return Collections.unmodifiableSet(this.modules);
        }

        public String getLang() {
            return this.lang;
        }

        public boolean isDuplicates() {
            return this.duplicates;
        }

        public boolean isExtractEmbedded() {
            return this.extractEmbedded;
        }

        public boolean isOverwriteOriginal() {
            return this.overwriteOriginal == OverwriteMode.COPY;
        }

        public boolean isOverwriteOriginalInPlace() {
            return this.overwriteOriginal == OverwriteMode.IN_PLACE;
        }

        public String toString() {
            return ToStringBuilder.create(this.getClass()).append("format", this.format).append("ignoreMinorErrors", this.ignoreMinorErrors).append("coordFormat", this.coordFormat).append("dateFormat", this.dateFormat).append("charset", this.charset).append("password", this.password).append("modules", this.modules).append("escapeHtml", this.escapeHtml).append("escapeXml", this.escapeXml).append("lang", this.lang).append("duplicates", this.duplicates).append("extractEmbedded", this.extractEmbedded).append("overwriteOriginal", (Object)this.overwriteOriginal).build();
        }
    }
}

