/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.cache;

import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.VersionCache;
import com.thebuzzmedia.exiftool.commons.exceptions.Exceptions;
import com.thebuzzmedia.exiftool.core.cache.VersionCallable;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

class DefaultVersionCache
implements VersionCache {
    private final ConcurrentMap<String, Future<Version>> cache = new ConcurrentHashMap<String, Future<Version>>();

    DefaultVersionCache() {
    }

    @Override
    public Version load(String exifTool, CommandExecutor executor) {
        boolean interrupted = false;
        Version version = null;
        while (version == null) {
            VersionCallable callable;
            FutureTask<Version> newTask;
            FutureTask<Version> task = (FutureTask<Version>)this.cache.get(exifTool);
            if (task == null && (task = (Future)this.cache.putIfAbsent(exifTool, newTask = new FutureTask<Version>(callable = new VersionCallable(exifTool, executor)))) == null) {
                task = newTask;
                newTask.run();
            }
            try {
                version = (Version)task.get();
            }
            catch (CancellationException e) {
                this.cache.remove(exifTool, task);
            }
            catch (InterruptedException ex) {
                this.cache.remove(exifTool, task);
                interrupted = true;
            }
            catch (ExecutionException ex) {
                throw Exceptions.launderThrowable(ex.getCause());
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return version;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }
}

