/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.exceptions;

import com.thebuzzmedia.exiftool.exceptions.AbstractExifException;
import com.thebuzzmedia.exiftool.process.CommandResult;
import java.io.IOException;

public class ExifToolNotFoundException
extends AbstractExifException {
    private final String path;
    private final CommandResult result;

    public ExifToolNotFoundException(String path, CommandResult result) {
        super(ExifToolNotFoundException.message(path));
        this.path = path;
        this.result = result;
    }

    public ExifToolNotFoundException(IOException ex, String path) {
        super(ex);
        this.path = path;
        this.result = null;
    }

    public String getPath() {
        return this.path;
    }

    public CommandResult getResult() {
        return this.result;
    }

    private static String message(String path) {
        return String.format("Cannot find exiftool from path: %s", path);
    }
}

