/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.process.executor;

import com.thebuzzmedia.exiftool.process.OutputHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CompositeHandler
implements OutputHandler {
    private final List<OutputHandler> handlers;

    CompositeHandler(OutputHandler ... handlers) {
        ArrayList list = new ArrayList(handlers.length);
        if (handlers.length > 0) {
            Collections.addAll(list, handlers);
        }
        this.handlers = Collections.unmodifiableList(list);
    }

    @Override
    public boolean readLine(String line) {
        boolean hasNext = true;
        for (OutputHandler handler : this.handlers) {
            if (handler.readLine(line)) continue;
            hasNext = false;
        }
        return hasNext;
    }
}

