/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oshi.jna.platform.mac.CoreFoundation;

public class CfUtil {
    public static final CoreFoundation.CFAllocatorRef ALLOCATOR = CoreFoundation.INSTANCE.CFAllocatorGetDefault();
    private static Map<String, CoreFoundation.CFStringRef> cfStringMap = new ConcurrentHashMap<String, CoreFoundation.CFStringRef>();

    public static CoreFoundation.CFStringRef getCFString(String key) {
        return cfStringMap.computeIfAbsent(key, CoreFoundation.CFStringRef::toCFString);
    }

    public static long cfPointerToLong(Pointer p) {
        LongByReference lbr = new LongByReference();
        CoreFoundation.INSTANCE.CFNumberGetValue(p, CFNumberType.kCFNumberLongLongType.ordinal(), (ByReference)lbr);
        return lbr.getValue();
    }

    public static int cfPointerToInt(Pointer p) {
        IntByReference ibr = new IntByReference();
        CoreFoundation.INSTANCE.CFNumberGetValue(p, CFNumberType.kCFNumberIntType.ordinal(), (ByReference)ibr);
        return ibr.getValue();
    }

    public static boolean cfPointerToBoolean(Pointer p) {
        return CoreFoundation.INSTANCE.CFBooleanGetValue(p);
    }

    public static String cfPointerToString(Pointer p) {
        if (p == null) {
            return "null";
        }
        long length = CoreFoundation.INSTANCE.CFStringGetLength(p);
        long maxSize = CoreFoundation.INSTANCE.CFStringGetMaximumSizeForEncoding(length, 0x8000100);
        if (maxSize == 0L) {
            maxSize = 1L;
        }
        Memory buf = new Memory(maxSize);
        CoreFoundation.INSTANCE.CFStringGetCString(p, (Pointer)buf, maxSize, 0x8000100);
        return buf.getString(0L);
    }

    public static void release(PointerType ref) {
        if (ref != null) {
            CoreFoundation.INSTANCE.CFRelease(ref);
        }
    }

    public static enum CFNumberType {
        unusedZero,
        kCFNumberSInt8Type,
        kCFNumberSInt16Type,
        kCFNumberSInt32Type,
        kCFNumberSInt64Type,
        kCFNumberFloat32Type,
        kCFNumberFloat64Type,
        kCFNumberCharType,
        kCFNumberShortType,
        kCFNumberIntType,
        kCFNumberLongType,
        kCFNumberLongLongType,
        kCFNumberFloatType,
        kCFNumberDoubleType,
        kCFNumberCFIndexType,
        kCFNumberNSIntegerType,
        kCFNumberCGFloatType,
        kCFNumberMaxType;

    }
}

