/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;

public enum CollectionTypeMappings {
    HASH_SET(HashSet.class, "array"),
    TREE_SET(TreeSet.class, "array"),
    LINKED_HASH_SET(LinkedHashSet.class, "array"),
    ARRAY_LIST(ArrayList.class, "array"),
    LINKED_LIST(LinkedList.class, "array"),
    ARRAY_DEQUE(ArrayDeque.class, "array"),
    ABSTRACT_COLLECTION(AbstractCollection.class, "array");

    private static final Map<Class<?>, String> MAPPINGS;
    private final Class<?> c;
    private final String schemaType;

    private CollectionTypeMappings(Class<?> c, String schemaType) {
        this.c = c;
        this.schemaType = schemaType;
    }

    public static String forClass(Class<?> c) {
        return MAPPINGS.get(c);
    }

    static {
        MAPPINGS = new IdentityHashMap();
        for (CollectionTypeMappings mapping : CollectionTypeMappings.values()) {
            MAPPINGS.put(mapping.c, mapping.schemaType);
        }
    }
}

