/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.reinert.jjschema.Nullable;
import com.github.reinert.jjschema.v1.SchemaWrapper;
import java.math.BigDecimal;

public class EnumSchemaWrapper
extends SchemaWrapper {
    public <T> EnumSchemaWrapper(Class<T> type) {
        super(type);
        this.processEnum(type);
        this.processNullable();
    }

    @Override
    public boolean isEnumWrapper() {
        return true;
    }

    @Override
    protected void processNullable() {
        Nullable nullable = this.getJavaType().getAnnotation(Nullable.class);
        if (nullable != null) {
            ((ArrayNode)this.getNode().get("enum")).add("null");
        }
    }

    private <T> void processEnum(Class<T> type) {
        ArrayNode enumArray = this.getNode().putArray("enum");
        for (T constant : type.getEnumConstants()) {
            String value = constant.toString();
            try {
                Long integer = Long.parseLong(value);
                enumArray.add(integer);
                this.setType("integer");
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal number = new BigDecimal(value);
                    enumArray.add(number);
                    this.setType("number");
                }
                catch (NumberFormatException e1) {
                    enumArray.add(value);
                    this.setType("string");
                }
            }
        }
    }
}

