/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.interval;

import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsQueryInterval;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.utils.ValidationUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HtsIntervalUtils {
    public static QueryInterval toQueryInterval(HtsInterval interval, SAMSequenceDictionary dictionary) {
        return new QueryInterval(dictionary.getSequenceIndex(interval.getQueryName()), HtsIntervalUtils.toIntegerSafe(interval.getStart()), HtsIntervalUtils.toIntegerSafe(interval.getEnd()));
    }

    public static Locatable toLocatable(final HtsInterval interval) {
        return new Locatable(){

            @Override
            public String getContig() {
                return interval.getQueryName();
            }

            @Override
            public int getStart() {
                return HtsIntervalUtils.toIntegerSafe(interval.getStart());
            }

            @Override
            public int getEnd() {
                return HtsIntervalUtils.toIntegerSafe(interval.getEnd());
            }

            public String toString() {
                return String.format("%s:%s-%s", interval.getQueryName(), interval.getStart(), interval.getEnd());
            }
        };
    }

    public static List<Locatable> toLocatableList(List<HtsInterval> intervals) {
        ValidationUtils.nonNull(intervals, "interval list");
        return intervals.stream().map(si -> HtsIntervalUtils.toLocatable(si)).collect(Collectors.toList());
    }

    public static QueryInterval[] toQueryIntervalArray(List<HtsInterval> intervals, SAMSequenceDictionary dictionary) {
        ValidationUtils.nonNull(intervals, "interval list");
        ValidationUtils.nonNull(dictionary, "SAMSequenceDictionary");
        return intervals.stream().map(si -> HtsIntervalUtils.toQueryInterval(si, dictionary)).collect(Collectors.toList()).toArray(new QueryInterval[intervals.size()]);
    }

    public static List<HtsInterval> fromQueryIntervalArray(QueryInterval[] queryIntervals, SAMSequenceDictionary dictionary) {
        return Arrays.stream(queryIntervals).map(si -> new HtsQueryInterval((QueryInterval)si, dictionary)).collect(Collectors.toList());
    }

    public static int toIntegerSafe(long coord) {
        try {
            return Math.toIntExact(coord);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(String.format("long to int conversion of %ld results in integer overflow", coord), e);
        }
    }
}

