/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.interval;

import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.utils.ValidationUtils;

public class HtsQueryInterval
implements HtsInterval {
    private final String queryName;
    private final long start;
    private final long end;

    public HtsQueryInterval(String queryName, long start, long end) {
        this.queryName = queryName;
        this.start = start;
        this.end = end;
    }

    public HtsQueryInterval(QueryInterval queryInterval, SAMSequenceDictionary dictionary) {
        ValidationUtils.nonNull(dictionary, "a valid sequence dictionary is required");
        ValidationUtils.nonNull(dictionary.getSequence(queryInterval.referenceIndex), String.format("query index %d is not present in the provided dictionary", queryInterval.referenceIndex));
        ValidationUtils.nonNull(dictionary.getSequence(queryInterval.referenceIndex).getContig(), String.format("contig name for index %d is not present in the provided dictionary", queryInterval.referenceIndex));
        this.queryName = dictionary.getSequence(queryInterval.referenceIndex).getContig();
        this.start = queryInterval.start;
        this.end = queryInterval.end;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }
}

