/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;

public class AvoidConstantAsFirstOperandInConditionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.constant.as.first.operand.in.condition";
    private int[] targetConstantTypes = new int[]{133, 134, 135, 137, 140, 141, 142};

    public void setTargetConstantTypes(String ... targets) {
        if (targets != null) {
            this.targetConstantTypes = new int[targets.length];
            for (int index = 0; index < targets.length; ++index) {
                this.targetConstantTypes[index] = TokenUtil.getTokenId((String)targets[index]);
            }
            Arrays.sort(this.targetConstantTypes);
        }
    }

    public int[] getDefaultTokens() {
        return new int[]{116, 115, 117, 119, 118, 120};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST detailAST) {
        if (this.isRefactoringRequired(detailAST)) {
            this.log(detailAST, MSG_KEY, new Object[]{detailAST.getText()});
        }
    }

    private boolean isRefactoringRequired(DetailAST logicNode) {
        DetailAST[] children = AvoidConstantAsFirstOperandInConditionCheck.getBothChildren(logicNode);
        DetailAST firstOperand = children[0];
        DetailAST secondOperand = children[1];
        int constantType = firstOperand.getType();
        return this.isTargetConstantType(constantType) && secondOperand.getType() != firstOperand.getType();
    }

    private static DetailAST[] getBothChildren(DetailAST logicNode) {
        DetailAST[] children = new DetailAST[2];
        int index = 0;
        for (DetailAST child = logicNode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() == 76 || child.getType() == 77) continue;
            children[index++] = child;
        }
        return children;
    }

    private boolean isTargetConstantType(int targetType) {
        return Arrays.binarySearch(this.targetConstantTypes, targetType) > -1;
    }
}

