/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Deque;
import java.util.LinkedList;

public class NoMainMethodInAbstractClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "avoid.main.method.in.abstract.class";
    private static final String STRING_CLASS = "String";
    private final Deque<DetailAST> objBlockTokensStack = new LinkedList<DetailAST>();

    public final int[] getDefaultTokens() {
        return new int[]{14, 9};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public final void visitToken(DetailAST ast) {
        if (ast.getType() == 14) {
            if (this.isNotInnerClass(ast)) {
                this.objBlockTokensStack.clear();
            }
            if (NoMainMethodInAbstractClassCheck.hasAbstractModifier(ast)) {
                this.objBlockTokensStack.push(ast.findFirstToken(6));
            }
        } else if (this.isChildOfCurrentObjBlockToken(ast) && NoMainMethodInAbstractClassCheck.isMainMethod(ast)) {
            this.log(ast, MSG_KEY, new Object[0]);
            this.objBlockTokensStack.pop();
        }
    }

    private boolean isNotInnerClass(DetailAST classDefAST) {
        boolean result = true;
        DetailAST objBlockAST = classDefAST.getParent();
        for (DetailAST currentObjBlock : this.objBlockTokensStack) {
            if (objBlockAST != currentObjBlock) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isChildOfCurrentObjBlockToken(DetailAST methodDefAST) {
        DetailAST objBlockAST = this.objBlockTokensStack.peek();
        return objBlockAST != null && methodDefAST.getParent() == objBlockAST;
    }

    private static boolean hasAbstractModifier(DetailAST classDefAST) {
        DetailAST modifiers = classDefAST.findFirstToken(5);
        return NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 40);
    }

    private static boolean isMainMethod(DetailAST methodAST) {
        String methodName = NoMainMethodInAbstractClassCheck.getIdentifier(methodAST);
        boolean result = "main".equals(methodName) ? NoMainMethodInAbstractClassCheck.isVoidType(methodAST) && NoMainMethodInAbstractClassCheck.isMainMethodModifiers(methodAST) && NoMainMethodInAbstractClassCheck.isMainMethodParameters(methodAST) : false;
        return result;
    }

    private static String getIdentifier(DetailAST ast) {
        DetailAST ident = ast.findFirstToken(58);
        return ident.getText();
    }

    private static boolean isMainMethodModifiers(DetailAST methodAST) {
        DetailAST modifiers = methodAST.findFirstToken(5);
        return NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 62) && NoMainMethodInAbstractClassCheck.hasChildToken(modifiers, 64);
    }

    private static boolean isVoidType(DetailAST methodAST) {
        DetailAST methodTypeAST = methodAST.findFirstToken(13);
        return NoMainMethodInAbstractClassCheck.hasChildToken(methodTypeAST, 49);
    }

    private static boolean isMainMethodParameters(DetailAST methodAST) {
        DetailAST params = methodAST.findFirstToken(20);
        return NoMainMethodInAbstractClassCheck.hasOnlyStringArrayParameter(params) || NoMainMethodInAbstractClassCheck.hasOnlyStringEllipsisParameter(params);
    }

    private static boolean hasOnlyStringArrayParameter(DetailAST parametersAST) {
        boolean result;
        if (parametersAST.getChildCount(21) == 1) {
            DetailAST parameterDefinitionAST = parametersAST.findFirstToken(21);
            DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
            if (NoMainMethodInAbstractClassCheck.hasChildToken(parameterTypeAST, 17)) {
                String parameterName = parameterTypeAST.getFirstChild().getText();
                result = STRING_CLASS.equals(parameterName);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static boolean hasOnlyStringEllipsisParameter(DetailAST parametersAST) {
        boolean result;
        if (parametersAST.getChildCount(21) == 1) {
            DetailAST parameterDefinitionAST = parametersAST.findFirstToken(21);
            if (NoMainMethodInAbstractClassCheck.hasChildToken(parameterDefinitionAST, 171)) {
                DetailAST parameterTypeAST = parameterDefinitionAST.findFirstToken(13);
                String parameterName = NoMainMethodInAbstractClassCheck.getIdentifier(parameterTypeAST);
                result = STRING_CLASS.equals(parameterName);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST ast, int tokenType) {
        return ast.findFirstToken(tokenType) != null;
    }
}

