/*
 * Decompiled with CFR 0.152.
 */
package com.smartdoc.gradle.chain;

import com.smartdoc.gradle.chain.FilterChain;
import com.smartdoc.gradle.model.CustomArtifact;
import java.util.HashSet;
import java.util.Set;

public class ContainsFilterChain
implements FilterChain {
    private static final Set<String> CONTAINS_SET = new HashSet<String>();
    private FilterChain filterChain;

    @Override
    public void setNext(FilterChain nextInChain) {
        this.filterChain = nextInChain;
    }

    @Override
    public boolean ignoreArtifactById(CustomArtifact artifact) {
        String artifactId = artifact.getArtifactId();
        if (CONTAINS_SET.stream().anyMatch(artifactId::contains)) {
            return true;
        }
        return this.ignore(this.filterChain, artifact);
    }

    static {
        CONTAINS_SET.add("log4j");
        CONTAINS_SET.add("logback");
        CONTAINS_SET.add("slf4j");
        CONTAINS_SET.add("swagger");
    }
}

