/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.common.model.EnumDictionary;
import com.power.common.util.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ApiDataDictionary {
    private String title;
    private Class<?> enumClass;
    private Set<Class<? extends Enum>> enumImplementSet;
    private String enumClassName;
    private String codeField;
    private String descField;

    public static ApiDataDictionary builder() {
        return new ApiDataDictionary();
    }

    public String getTitle() {
        return this.title;
    }

    public ApiDataDictionary setTitle(String title) {
        this.title = title;
        return this;
    }

    public Class getEnumClass() {
        return this.enumClass;
    }

    public ApiDataDictionary setEnumClass(Class<?> enumClass) {
        this.enumClass = enumClass;
        if (StringUtils.isBlank((CharSequence)this.enumClassName) && Objects.nonNull(enumClass)) {
            this.enumClassName = enumClass.getSimpleName();
        }
        return this;
    }

    public Set<Class<? extends Enum>> getEnumImplementSet() {
        return this.enumImplementSet;
    }

    public ApiDataDictionary setEnumImplementSet(Set<Class<? extends Enum>> enumImplementSet) {
        this.enumImplementSet = enumImplementSet;
        return this;
    }

    public String getCodeField() {
        return this.codeField;
    }

    public ApiDataDictionary setCodeField(String codeField) {
        this.codeField = codeField;
        return this;
    }

    public String getDescField() {
        return this.descField;
    }

    public ApiDataDictionary setDescField(String descField) {
        this.descField = descField;
        return this;
    }

    public String getEnumClassName() {
        return this.enumClassName;
    }

    public ApiDataDictionary setEnumClassName(String enumClassName) {
        this.enumClassName = enumClassName;
        return this;
    }

    public List<EnumDictionary> getEnumDataDict(Class enumClass) {
        if (Objects.nonNull(enumClass)) {
            return EnumUtil.getEnumInformation((Class)enumClass, (String)this.getCodeField(), (String)this.getDescField());
        }
        return new ArrayList<EnumDictionary>();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"title\":\"").append(this.title).append('\"');
        sb.append(",\"enumClass\":").append(this.enumClass);
        sb.append(",\"enumClassName\":\"").append(this.enumClassName).append('\"');
        sb.append(",\"codeField\":\"").append(this.codeField).append('\"');
        sb.append(",\"descField\":\"").append(this.descField).append('\"');
        sb.append('}');
        return sb.toString();
    }
}

