package six42.fitnesse.jdbcslim;

import fitnesse.testsystems.CompositeTestSystemListener;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.html.HtmlUtil;
import fitnesse.html.template.PageTitle;
/**
 * A simple example implementation. It outputs the page's wiki text as verbatim
 * output.
 */
public class EchoTestSystemFactory implements TestSystemFactory {
  @Override
  public TestSystem create(Descriptor descriptor) {
    return new EchoTestSystem();
  }

  public static class EchoTestSystem implements TestSystem {
    private final CompositeTestSystemListener testSystemListener;

    public EchoTestSystem() {
      testSystemListener = new CompositeTestSystemListener();
    }

    @Override
    public String getName() {
      return "Example";
    }

    @Override
    public void start() {
      // Nothing to do, except sending an event
      testSystemListener.testSystemStarted(this);
    }

    @Override
    public void bye() {

      // We're done
      testSystemListener.testSystemStopped(this, null);
    }

    @Override
    public void kill() {
      // We're really done
      testSystemListener.testSystemStopped(this, null);
    }

    @Override
    public void runTests(TestPage pageToTest) {
      testSystemListener.testStarted(pageToTest);
      String htmlPage = pageToTest.getHtml();
      htmlPage = htmlPage.replaceAll("href=\"([^\"]+)\"", "href=\"$1.html\"");
      htmlPage = htmlPage.replaceAll(">\\(edit\\)<", "><");
      PageTitle pT = new PageTitle(pageToTest.getFullPath(), "\\.");
      String bCString = "";
      for (PageTitle.BreadCrumb b : pT.getBreadCrumbs()){
        bCString = bCString
            + HtmlUtil.makeLink(b.getLink().replaceAll("\\\\", "") + ".html",
                b.getName()).html();
      }
      htmlPage = "<h2>" + bCString + "</h2></br>" + htmlPage;
      testSystemListener.testOutputChunk(htmlPage);
      testSystemListener.testComplete(pageToTest, new TestSummary(1, 0, 0, 0));
    }

    @Override
    public boolean isSuccessfullyStarted() {
      // Can be used to check on asynchronously started processes.
      return true;
    }

    @Override
    public void addTestSystemListener(TestSystemListener listener) {
      testSystemListener.addTestSystemListener(listener);
    }
  }
}
