/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.spotbugs;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.xml.XmlParser;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codehaus.mojo.spotbugs.SpotBugsInfo;

public abstract class BaseViolationCheckMojo
extends AbstractMojo
implements GroovyObject {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File spotbugsXmlOutputDirectory;
    @Parameter(defaultValue="spotbugsXml.xml", property="spotbugs.outputXmlFilename")
    private String spotbugsXmlOutputFilename;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classFilesDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    private File testClassFilesDirectory;
    @Parameter(defaultValue="false", property="spotbugs.includeTests")
    private boolean includeTests;
    @Parameter(defaultValue="false", property="spotbugs.debug")
    private boolean debug;
    @Parameter(defaultValue="false", property="spotbugs.skip")
    private boolean skip;
    @Parameter(defaultValue="true", property="spotbugs.failOnError")
    private boolean failOnError;
    @Parameter(property="spotbugs.failThreshold")
    private String failThreshold;
    @Parameter(defaultValue="0", property="spotbugs.maxAllowedViolations")
    private int maxAllowedViolations;
    @Parameter(defaultValue="false", property="spotbugs.quiet")
    private boolean quiet;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public BaseViolationCheckMojo() {
        this.metaClass = this.$getStaticMetaClass();
    }

    public void execute() {
        Reference priorityThresholdNum;
        CallSite outputFile;
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "Executing spotbugs mojo");
        if (this.skip) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "Spotbugs plugin skipped");
            return;
        }
        if ((IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "doSourceFilesExist", 2, this)) ^ 1) != 0) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "Nothing for SpotBugs to do here.");
            return;
        }
        IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "Files found to process spotbugs");
        CallSite outputDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toPath", 0, this.spotbugsXmlOutputDirectory));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "notExists", 0, Files.class, outputDir)) != false) {
            try {
                IndyInterface.bootstrap("invoke", "createDirectories", 0, Files.class, outputDir);
            }
            catch (IOException e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, "Cannot create xml output directory", e));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "notExists", 0, Files.class, outputFile = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolve", 0, outputDir, this.spotbugsXmlOutputFilename)))) != false) {
            IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "Output file does not exist!");
            return;
        }
        CallSite xml = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, XmlParser.class), IndyInterface.bootstrap("invoke", "toFile", 0, outputFile)));
        CallSite bugs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "BugInstance", 0, xml));
        int bugCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, bugs));
        int errorCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "Error", 0, xml)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), new GStringImpl(new Object[]{bugCount}, new String[]{"BugInstance size is ", ""}));
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), new GStringImpl(new Object[]{errorCount}, new String[]{"Error size is ", ""}));
        }
        if (bugCount <= 0) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), "No errors/warnings found");
            return;
        }
        if (this.maxAllowedViolations > 0 && bugCount <= this.maxAllowedViolations) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
                IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{bugCount}, new String[]{"Total ", " violations are found as acceptable using configured property maxAllowedViolations "}), new GStringImpl(new Object[]{this.maxAllowedViolations, IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)}, new String[]{":", ".", "Below are list of bugs ignored :", ""})));
            }
            IndyInterface.bootstrap("invoke", "printBugs", 2, this, bugs);
            return;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "plus", 0, "Total bugs: ", bugCount));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Integer)(priorityThresholdNum = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.failThreshold) != false ? IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), this.failThreshold) : IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class)))).get()), (Object)-1)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{this.failThreshold}, new String[]{"Invalid value for failThreshold: ", ""})));
        }
        Reference bugCountAboveThreshold = new Reference((Object)0);
        public final class _execute_closure1
        extends Closure
        implements GeneratedClosure {
            private static final long serialVersionUID = -2225683187477748075L;
            private /* synthetic */ Reference priorityThresholdNum;
            private /* synthetic */ Reference bugCountAboveThreshold;
            private static /* synthetic */ long $const$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure1(Object _outerInstance, Object _thisObject, Reference priorityThresholdNum, Reference bugCountAboveThreshold) {
                super(_outerInstance, _thisObject);
                this.priorityThresholdNum = priorityThresholdNum;
                this.bugCountAboveThreshold = bugCountAboveThreshold;
            }

            public Object doCall(Node bug) {
                int priorityNum = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "toInteger", 0, IndyInterface.bootstrap("getProperty", "@priority", 0, bug)));
                if (ScriptBytecodeAdapter.compareLessThanEqual((Object)priorityNum, (Object)IndyInterface.bootstrap("cast", "()", 0, this.priorityThresholdNum.get()))) {
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.bugCountAboveThreshold.get());
                    this.bugCountAboveThreshold.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "quiet", 8, this)) ^ true && (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)))) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)))))) {
                    CallSite logMsg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "spotbugsPriority", 0, SpotBugsInfo.class), priorityNum), ": "), IndyInterface.bootstrap("invoke", "bugLog", 2, this, bug)));
                    if (ScriptBytecodeAdapter.compareLessThanEqual((Object)priorityNum, (Object)IndyInterface.bootstrap("cast", "()", 0, this.priorityThresholdNum.get()))) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)))) != false) {
                            return IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)), logMsg);
                        }
                    } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)))) != false) {
                        return IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 8, this)), logMsg);
                    }
                }
                return null;
            }

            @Generated
            public Object call(Node bug) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, bug);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            static {
                _execute_closure1.$const$0 = -2225683187477748075L;
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, bugs, new _execute_closure1((Object)this, (Object)this, priorityThresholdNum, bugCountAboveThreshold));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), "To see bug detail using the Spotbugs GUI, use the following command \"mvn spotbugs:gui\""), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class)));
        }
        if ((DefaultTypeTransformation.booleanUnbox((Object)((Integer)bugCountAboveThreshold.get())) || DefaultTypeTransformation.booleanUnbox((Object)errorCount)) && this.failOnError) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MojoExecutionException.class, new GStringImpl(new Object[]{(Integer)bugCountAboveThreshold.get(), errorCount}, new String[]{"failed with ", " bugs and ", " errors"})));
        }
    }

    private boolean doSourceFilesExist() {
        boolean foundClassFiles = false;
        List classFilesList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDirectory", 0, this.classFilesDirectory)) != false) {
            foundClassFiles = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "walkFiles", 2, this, classFilesList, this.classFilesDirectory, foundClassFiles));
        }
        boolean foundTestFiles = false;
        List testFilesList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (this.includeTests && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isDirectory", 0, this.testClassFilesDirectory))) {
            foundTestFiles = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "walkFiles", 2, this, testFilesList, this.testClassFilesDirectory, foundTestFiles));
        }
        return foundClassFiles || foundTestFiles;
    }

    /*
     * WARNING - void declaration
     */
    private boolean walkFiles(List filesList, File filesDirectory, boolean foundFiles22) {
        void foundFiles22;
        Reference filesList2 = new Reference((Object)filesList);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "plus", 0, "looking for files with extensions: ", IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class)));
            public final class _walkFiles_closure2
            extends Closure
            implements GeneratedClosure {
                private static final long serialVersionUID = -4414462732207937959L;
                private static /* synthetic */ long $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _walkFiles_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Path path) {
                    Reference path2 = new Reference((Object)path);
                    public final class _closure6
                    extends Closure
                    implements GeneratedClosure {
                        private static final long serialVersionUID = 5910965420993130171L;
                        private /* synthetic */ Reference path;
                        private static /* synthetic */ long $const$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure6(Object _outerInstance, Object _thisObject, Reference path) {
                            super(_outerInstance, _thisObject);
                            this.path = path;
                        }

                        public Object doCall(String ext) {
                            return IndyInterface.bootstrap("invoke", "endsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())), IndyInterface.bootstrap("invoke", "getDefault", 0, Locale.class)), ext);
                        }

                        @Generated
                        public Object call(String ext) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, ext);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        static {
                            _closure6.$const$0 = 5910965420993130171L;
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class), new _closure6((Object)this, this.getThisObject(), path2));
                }

                @Generated
                public Object call(Path path) {
                    Reference path2 = new Reference((Object)path);
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, (Path)path2.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _walkFiles_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                static {
                    _walkFiles_closure2.$const$0 = -4414462732207937959L;
                }
            }
            public final class _walkFiles_closure3
            extends Closure
            implements GeneratedClosure {
                private static final long serialVersionUID = -1674065819011838543L;
                private /* synthetic */ Reference filesList;
                private static /* synthetic */ long $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _walkFiles_closure3(Object _outerInstance, Object _thisObject, Reference filesList) {
                    super(_outerInstance, _thisObject);
                    this.filesList = filesList;
                }

                public Object doCall(Path path) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.filesList.get()), IndyInterface.bootstrap("invoke", "toString", 0, path));
                }

                @Generated
                public Object call(Path path) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, path);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _walkFiles_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                static {
                    _walkFiles_closure3.$const$0 = -1674065819011838543L;
                }
            }
            IndyInterface.bootstrap("invoke", "forEach", 0, IndyInterface.bootstrap("invoke", "filter", 0, IndyInterface.bootstrap("invoke", "walk", 0, Files.class, IndyInterface.bootstrap("invoke", "toPath", 0, filesDirectory)), new _walkFiles_closure2((Object)this, (Object)this)), new _walkFiles_closure3((Object)this, (Object)this, filesList2));
            int foundFiles22 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, (List)filesList2.get())) ^ 1;
        } else {
            public final class _walkFiles_closure4
            extends Closure
            implements GeneratedClosure {
                private static final long serialVersionUID = -8050267141213382146L;
                private static /* synthetic */ long $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _walkFiles_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Path path) {
                    Reference path2 = new Reference((Object)path);
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private static final long serialVersionUID = 9045987452623315162L;
                        private /* synthetic */ Reference path;
                        private static /* synthetic */ long $const$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject, Reference path) {
                            super(_outerInstance, _thisObject);
                            this.path = path;
                        }

                        public Object doCall(String ext) {
                            return IndyInterface.bootstrap("invoke", "endsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("cast", "()", 0, this.path.get())), IndyInterface.bootstrap("invoke", "getDefault", 0, Locale.class)), ext);
                        }

                        @Generated
                        public Object call(String ext) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, ext);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        static {
                            _closure7.$const$0 = 9045987452623315162L;
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "EXTENSIONS", 0, SpotBugsInfo.class), new _closure7((Object)this, this.getThisObject(), path2));
                }

                @Generated
                public Object call(Path path) {
                    Reference path2 = new Reference((Object)path);
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, (Path)path2.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _walkFiles_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                static {
                    _walkFiles_closure4.$const$0 = -8050267141213382146L;
                }
            }
            boolean foundFiles22 = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "anyMatch", 0, IndyInterface.bootstrap("invoke", "walk", 0, Files.class, IndyInterface.bootstrap("invoke", "toPath", 0, filesDirectory)), new _walkFiles_closure4((Object)this, (Object)this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), new GStringImpl(new Object[]{(boolean)foundFiles22, IndyInterface.bootstrap("invoke", "size", 0, (List)filesList2.get())}, new String[]{"SourceFiles found flag: ", " with count: ", ""}));
            if ((IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, (List)filesList2.get())) ^ 1) != 0) {
                IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "plus", 0, "Files found: ", (List)filesList2.get()));
            }
        }
        return (boolean)foundFiles22;
    }

    private void printBugs(NodeList bugs) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)))) != false) {
            Reference sb = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class)));
            public final class _printBugs_closure5
            extends Closure
            implements GeneratedClosure {
                private static final long serialVersionUID = -1433837107743194594L;
                private /* synthetic */ Reference sb;
                private static /* synthetic */ long $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _printBugs_closure5(Object _outerInstance, Object _thisObject, Reference sb) {
                    super(_outerInstance, _thisObject);
                    this.sb = sb;
                }

                public Object doCall(Node bug) {
                    return IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("cast", "()", 0, this.sb.get()), IndyInterface.bootstrap("invoke", "bugLog", 2, this, bug)), IndyInterface.bootstrap("getProperty", "EOL", 0, SpotBugsInfo.class));
                }

                @Generated
                public Object call(Node bug) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, bug);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _printBugs_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                static {
                    _printBugs_closure5.$const$0 = -1433837107743194594L;
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, bugs, new _printBugs_closure5((Object)this, (Object)this, sb));
            IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "log", 12, this)), IndyInterface.bootstrap("invoke", "toString", 0, (StringBuilder)sb.get()));
        }
    }

    protected static String bugLog(Node bug) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "LongMessage", 0, bug)), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@classname", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("invoke", "text", 0, IndyInterface.bootstrap("getProperty", "Message", 0, IndyInterface.bootstrap("getProperty", "SourceLine", 0, bug)))), IndyInterface.bootstrap("getProperty", "BLANK", 0, SpotBugsInfo.class)), IndyInterface.bootstrap("getProperty", "@type", 0, bug)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BaseViolationCheckMojo.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public File getSpotbugsXmlOutputDirectory() {
        return this.spotbugsXmlOutputDirectory;
    }

    @Generated
    public void setSpotbugsXmlOutputDirectory(File file) {
        this.spotbugsXmlOutputDirectory = file;
    }

    @Generated
    public String getSpotbugsXmlOutputFilename() {
        return this.spotbugsXmlOutputFilename;
    }

    @Generated
    public void setSpotbugsXmlOutputFilename(String string) {
        this.spotbugsXmlOutputFilename = string;
    }

    @Generated
    public File getClassFilesDirectory() {
        return this.classFilesDirectory;
    }

    @Generated
    public void setClassFilesDirectory(File file) {
        this.classFilesDirectory = file;
    }

    @Generated
    public File getTestClassFilesDirectory() {
        return this.testClassFilesDirectory;
    }

    @Generated
    public void setTestClassFilesDirectory(File file) {
        this.testClassFilesDirectory = file;
    }

    @Generated
    public boolean getIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public boolean isIncludeTests() {
        return this.includeTests;
    }

    @Generated
    public void setIncludeTests(boolean bl) {
        this.includeTests = bl;
    }

    @Generated
    public boolean getDebug() {
        return this.debug;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Generated
    public boolean getSkip() {
        return this.skip;
    }

    @Generated
    public boolean isSkip() {
        return this.skip;
    }

    @Generated
    public void setSkip(boolean bl) {
        this.skip = bl;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    @Generated
    public String getFailThreshold() {
        return this.failThreshold;
    }

    @Generated
    public void setFailThreshold(String string) {
        this.failThreshold = string;
    }

    @Generated
    public int getMaxAllowedViolations() {
        return this.maxAllowedViolations;
    }

    @Generated
    public void setMaxAllowedViolations(int n) {
        this.maxAllowedViolations = n;
    }

    @Generated
    public boolean getQuiet() {
        return this.quiet;
    }

    @Generated
    public boolean isQuiet() {
        return this.quiet;
    }

    @Generated
    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }
}

