/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    private static final Map<String, Plugin> BUILD_IN_PLUGINS = Plugin.createBuildInPlugins();
    private String name;
    private boolean noOutput;
    private String extension;
    private File outputDirectory;

    private static Map<String, Plugin> createBuildInPlugins() {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        plugins.put("null", Plugin.createPluginWithoutOutput("null"));
        plugins.put("junit", new Plugin("junit", "xml"));
        plugins.put("testng", new Plugin("testng", "xml"));
        plugins.put("html", new Plugin("html", null));
        plugins.put("pretty", Plugin.createPluginWithoutOutput("pretty"));
        plugins.put("progress", new Plugin("progress", "txt"));
        plugins.put("json", new Plugin("json", "json"));
        plugins.put("usage", new Plugin("usage", "json"));
        plugins.put("rerun", new Plugin("rerun", "txt"));
        plugins.put("default_summary", Plugin.createPluginWithoutOutput("default_summary"));
        plugins.put("null_summary", Plugin.createPluginWithoutOutput("null_summary"));
        return plugins;
    }

    public boolean isNoOutput() {
        return this.noOutput;
    }

    public void setNoOutput(boolean noOutput) {
        this.noOutput = noOutput;
    }

    public Plugin() {
    }

    private Plugin(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    private Plugin(String name, boolean noOutput) {
        this.name = name;
        this.noOutput = noOutput;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    void applyDefaults(File defaultOutputDirectory) {
        if (BUILD_IN_PLUGINS.containsKey(this.name)) {
            this.applyDefaultsForBuildinPlugins();
        }
        if (this.isNoOutput()) {
            boolean bl = this.noOutput = this.outputDirectory == null && this.extension == null;
        }
        if (this.outputDirectory == null && !this.isNoOutput()) {
            this.outputDirectory = defaultOutputDirectory;
        }
    }

    private void applyDefaultsForBuildinPlugins() {
        Plugin knownPlugin = BUILD_IN_PLUGINS.get(this.name);
        if (this.extension == null) {
            this.extension = knownPlugin.getExtension();
        }
        this.noOutput = knownPlugin.isNoOutput();
        if (this.noOutput) {
            this.extension = null;
            this.outputDirectory = null;
        }
    }

    static Plugin createPluginWithoutOutput(String pluginString) {
        return new Plugin(pluginString, true);
    }

    static Plugin createBuildInPlugin(String name) {
        Plugin plugin = BUILD_IN_PLUGINS.get(name);
        if (plugin == null) {
            throw new IllegalArgumentException(name + " is not a build in cucumber plugin");
        }
        return new Plugin(plugin.name, plugin.extension);
    }

    String asPluginString(int fileCounter) {
        String formatStr = this.name;
        if (this.outputDirectory == null) {
            return formatStr;
        }
        formatStr = formatStr + ":" + Plugin.normalizePathSeparator(this.outputDirectory) + "/" + fileCounter;
        if (this.extension == null) {
            return formatStr;
        }
        return formatStr + "." + this.extension;
    }

    private static String normalizePathSeparator(File file) {
        return file.getPath().replace(File.separatorChar, '/');
    }

    public String toString() {
        return "Plugin{name='" + this.name + '\'' + ", noOutput=" + this.noOutput + ", extension='" + this.extension + '\'' + ", outputDirectory=" + this.outputDirectory + '}';
    }
}

