/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate.name;

import com.github.timm.cucumber.ModuloCounter;
import com.github.timm.cucumber.generate.name.ClassNamingScheme;
import com.github.timm.cucumber.generate.name.Counter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternNamingScheme
implements ClassNamingScheme {
    private static final Pattern COUNTER_PATTERN = Pattern.compile("\\{(\\d*)c}");
    private static final Pattern MODULO_COUNTER_PATTERN = Pattern.compile("\\{(\\d*)c:(\\d+)}");
    private final String pattern;
    private final Counter counter;
    private final Counter moduloCounter;
    private final ClassNamingScheme featureFileNamingScheme;

    public PatternNamingScheme(String pattern, Counter counter, ClassNamingScheme featureFileNamingScheme) {
        this.pattern = pattern;
        this.counter = counter;
        this.moduloCounter = new ModuloCounter(pattern);
        this.featureFileNamingScheme = featureFileNamingScheme;
    }

    public String generate(String featureFileName) {
        String className = this.pattern.replace("{f}", this.featureFileNamingScheme.generate(featureFileName));
        int number = this.counter.next();
        className = this.replaceAll(COUNTER_PATTERN, className, number);
        className = this.replaceAll(MODULO_COUNTER_PATTERN, className, number);
        return className;
    }

    private String replaceAll(Pattern compiledPattern, String pattern, int number) {
        Matcher matcher = compiledPattern.matcher(pattern);
        boolean isNormalCounter = compiledPattern == COUNTER_PATTERN;
        int defaultLen = isNormalCounter ? 2 : 1;
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                boolean isNoLength = matcher.start(1) == matcher.end(1);
                int len = isNoLength ? defaultLen : Integer.decode(matcher.group(1));
                int numberAdjustedIfMod = isNormalCounter ? number : (number - 1) % Integer.decode(matcher.group(2));
                matcher.appendReplacement(sb, String.format("%0" + len + "d", numberAdjustedIfMod));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return pattern;
    }
}

