/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.provider;

import com.github.tlrx.elasticsearch.test.provider.ClientProvider;
import java.io.File;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class LocalClientProvider
implements ClientProvider {
    private Node node = null;
    private Client client = null;
    private Settings settings = null;

    public LocalClientProvider() {
    }

    public LocalClientProvider(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void open() {
        if (this.node == null || this.node.isClosed()) {
            this.node = NodeBuilder.nodeBuilder().settings(this.buildNodeSettings()).node();
            this.client = this.node.client();
            this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setTimeout(TimeValue.timeValueMinutes((long)1L)).execute().actionGet();
        }
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public void close() {
        if (this.client() != null) {
            this.client.close();
        }
        if (this.node != null && !this.node.isClosed()) {
            this.node.close();
            FileSystemUtils.deleteRecursively((File)new File("./target/elasticsearch-test/"), (boolean)true);
        }
    }

    protected Settings buildNodeSettings() {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("node.name", "node-test-" + System.currentTimeMillis()).put("node.data", true).put("cluster.name", "cluster-test-" + NetworkUtils.getLocalAddress().getHostName()).put("index.store.type", "memory").put("index.store.fs.memory.enabled", "true").put("gateway.type", "none").put("path.data", "./target/elasticsearch-test/data").put("path.work", "./target/elasticsearch-test/work").put("path.logs", "./target/elasticsearch-test/logs").put("index.number_of_shards", "1").put("index.number_of_replicas", "0").put("cluster.routing.schedule", "50ms").put("node.local", true);
        if (this.settings != null) {
            builder.put(this.settings);
        }
        return builder.build();
    }
}

