/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.request;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.provider.JSONProvider;
import com.github.tlrx.elasticsearch.test.request.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class CreateIndex
implements Request<Void> {
    private final CreateIndexRequest request;
    private final String index;
    private final List<JSONProvider> bulks;

    public CreateIndex(String index) {
        this.index = index;
        this.request = new CreateIndexRequest(index);
        this.bulks = new ArrayList<JSONProvider>();
    }

    public CreateIndex withSettings(Settings settings) {
        this.request.settings(settings);
        return this;
    }

    public CreateIndex withSettings(String source) {
        Settings settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        this.withSettings(settings);
        return this;
    }

    public CreateIndex withSettings(JSONProvider jsonProvider) {
        this.withSettings(jsonProvider.toJson());
        return this;
    }

    public CreateIndex withMapping(String type, Map mapping) {
        this.request.mapping(type, mapping);
        return this;
    }

    public CreateIndex withMapping(String type, String source) {
        this.request.mapping(type, source);
        return this;
    }

    public CreateIndex withMapping(String type, JSONProvider jsonProvider) {
        this.withMapping(type, jsonProvider.toJson());
        return this;
    }

    public CreateIndex withSource(String source) {
        this.request.source(source);
        return this;
    }

    public CreateIndex withSource(JSONProvider jsonProvider) {
        this.request.source(jsonProvider.toJson());
        return this;
    }

    public CreateIndex withData(JSONProvider jsonProvider) {
        this.bulks.add(jsonProvider);
        return this;
    }

    @Override
    public Void execute(Client client) throws ElasticsearchException {
        BulkRequestBuilder bulkRequestBuilder = null;
        try {
            BulkResponse bulkResponse;
            CreateIndexResponse response;
            if (this.bulks != null && !this.bulks.isEmpty()) {
                bulkRequestBuilder = client.prepareBulk();
                for (JSONProvider jsonProvider : this.bulks) {
                    byte[] content = jsonProvider.toJson().getBytes("UTF-8");
                    bulkRequestBuilder.add(content, 0, content.length, true);
                }
            }
            if ((response = (CreateIndexResponse)client.admin().indices().create(this.request).get()).isAcknowledged() && bulkRequestBuilder != null && (bulkResponse = (BulkResponse)bulkRequestBuilder.setRefresh(true).execute().actionGet()).hasFailures()) {
                throw new EsSetupRuntimeException("Bulk request has failures: " + bulkResponse.buildFailureMessage());
            }
        }
        catch (Exception e) {
            throw new EsSetupRuntimeException(e);
        }
        return null;
    }

    public String toString() {
        return "create index [index='" + this.index + '\'' + ']';
    }
}

