/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations;

import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchAdminClient;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.FieldLevelElasticsearchAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.node.Node;

public class ElasticsearchAdminClientAnnotationHandler
implements FieldLevelElasticsearchAnnotationHandler {
    private static final Logger LOGGER = Logger.getLogger(ElasticsearchAdminClientAnnotationHandler.class.getName());

    @Override
    public boolean support(Annotation annotation) {
        return annotation instanceof ElasticsearchAdminClient;
    }

    @Override
    public void handleField(Annotation annotation, Object instance, Map<String, Object> context, Field field) {
        Node node;
        ElasticsearchAdminClient elasticsearchAdminClient = (ElasticsearchAdminClient)annotation;
        String nodeName = elasticsearchAdminClient.nodeName();
        if (nodeName != null && (node = (Node)context.get(nodeName)) != null) {
            try {
                field.setAccessible(true);
                field.set(instance, node.client().admin());
            }
            catch (Exception e) {
                LOGGER.severe("Unable to set node for field " + field.getName() + ": " + e.getMessage());
            }
        }
    }
}

