/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations;

import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchAnalysis;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchFilter;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchIndex;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchMapping;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchMappingField;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchSetting;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.MethodLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations.AbstractAnnotationHandler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class ElasticsearchIndexAnnotationHandler
extends AbstractAnnotationHandler
implements MethodLevelElasticsearchAnnotationHandler {
    private static final Logger LOGGER = Logger.getLogger(ElasticsearchIndexAnnotationHandler.class.getName());

    @Override
    public boolean support(Annotation annotation) {
        return annotation instanceof ElasticsearchIndex;
    }

    @Override
    public void handleBefore(Annotation annotation, Object instance, Map<String, Object> context) throws Exception {
        this.buildIndex((ElasticsearchIndex)annotation, context);
    }

    @Override
    public void handleAfter(Annotation annotation, Object instance, Map<String, Object> context) throws Exception {
        ElasticsearchIndex elasticsearchIndex = (ElasticsearchIndex)annotation;
        if (elasticsearchIndex.cleanAfter()) {
            this.clean(context, elasticsearchIndex.nodeName(), elasticsearchIndex.indexName());
        }
    }

    private void clean(Map<String, Object> context, String nodeName, String indexName) throws ElasticsearchException, Exception {
        this.client(context, nodeName).prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
    }

    private void deleteIndex(Map<String, Object> context, String nodeName, String indexName) throws ElasticsearchException, Exception {
        DeleteIndexResponse response = (DeleteIndexResponse)this.admin(context, nodeName).indices().prepareDelete(new String[]{indexName}).execute().actionGet();
        if (!response.isAcknowledged()) {
            throw new Exception("Could not delete index [" + indexName + "]");
        }
    }

    private void createIndex(Map<String, Object> context, String nodeName, String indexName, Settings settings) throws ElasticsearchException, Exception {
        CreateIndexResponse response;
        CreateIndexRequestBuilder builder = this.admin(context, nodeName).indices().prepareCreate(indexName);
        if (settings != null) {
            builder.setSettings(settings);
        }
        if (!(response = (CreateIndexResponse)builder.execute().actionGet()).isAcknowledged()) {
            throw new Exception("Could not create index [" + indexName + "]");
        }
    }

    private void putIndexMapping(Map<String, Object> context, String nodeName, String indexName, String type, XContentBuilder mappingBuilder) throws ElasticsearchException, Exception {
        PutMappingResponse response = (PutMappingResponse)this.admin(context, nodeName).indices().preparePutMapping(new String[]{indexName}).setType(type).setSource(mappingBuilder).execute().actionGet();
        if (!response.isAcknowledged()) {
            throw new Exception("Could not put mapping [" + type + "] for index [" + indexName + "]");
        }
    }

    protected void buildIndex(ElasticsearchIndex elasticsearchIndex, Map<String, Object> context) throws Exception {
        ElasticsearchMapping[] mappings;
        AdminClient admin = this.admin(context, elasticsearchIndex.nodeName());
        IndicesExistsResponse existResponse = (IndicesExistsResponse)admin.indices().prepareExists(new String[]{elasticsearchIndex.indexName()}).execute().actionGet();
        if (existResponse.isExists()) {
            if (elasticsearchIndex.forceCreate()) {
                this.deleteIndex(context, elasticsearchIndex.nodeName(), elasticsearchIndex.indexName());
                this.createIndex(context, elasticsearchIndex.nodeName(), elasticsearchIndex.indexName(), this.buildIndexSettings(elasticsearchIndex));
            }
        } else {
            this.createIndex(context, elasticsearchIndex.nodeName(), elasticsearchIndex.indexName(), this.buildIndexSettings(elasticsearchIndex));
        }
        for (ElasticsearchMapping mapping : mappings = elasticsearchIndex.mappings()) {
            this.putIndexMapping(context, elasticsearchIndex.nodeName(), elasticsearchIndex.indexName(), mapping.typeName(), this.buildMapping(mapping));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Settings buildIndexSettings(ElasticsearchIndex elasticsearchIndex) {
        void var9_14;
        ElasticsearchSetting[] indexSettings;
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        String settingsFile = "config/mappings/" + elasticsearchIndex.indexName() + "/_settings.json";
        if (elasticsearchIndex.settingsFile().length() > 0) {
            settingsFile = elasticsearchIndex.settingsFile();
        }
        Settings configSettings = ImmutableSettings.settingsBuilder().loadFromClasspath(settingsFile).build();
        settingsBuilder.put(configSettings);
        ElasticsearchAnalysis analysis = elasticsearchIndex.analysis();
        if (analysis != null && (analysis.filters().length > 0 || analysis.analyzers().length > 0)) {
            String prefix;
            for (ElasticsearchFilter elasticsearchFilter : analysis.filters()) {
                prefix = "index.analysis.filter." + elasticsearchFilter.name();
                settingsBuilder.put(prefix + ".type", elasticsearchFilter.typeName());
                for (ElasticsearchSetting setting : elasticsearchFilter.settings()) {
                    settingsBuilder.put(prefix + "." + setting.name(), setting.value());
                }
            }
            for (Annotation annotation : analysis.analyzers()) {
                prefix = "index.analysis.analyzer." + annotation.name();
                settingsBuilder.put(prefix + ".tokenizer", annotation.tokenizer());
                if (annotation.filtersNames() == null || annotation.filtersNames().length <= 0) continue;
                settingsBuilder.putArray(prefix + ".filter", annotation.filtersNames());
            }
        }
        ElasticsearchSetting[] arr$ = indexSettings = elasticsearchIndex.settings();
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_14 < len$) {
            ElasticsearchSetting setting = arr$[var9_14];
            settingsBuilder.put(setting.name(), setting.value());
            ++var9_14;
        }
        return settingsBuilder.build();
    }

    private XContentBuilder buildField(ElasticsearchMappingField field, XContentBuilder builder) throws IOException {
        builder = builder.startObject(field.name()).field("type", field.type().toString().toLowerCase()).field("store", field.store().toString().toLowerCase());
        if (!field.index().equals((Object)ElasticsearchMappingField.Index.Undefined)) {
            builder.field("index", field.index().toString().toLowerCase());
        }
        if (field.analyzerName() != null && !"default-analyzer".equals(field.analyzerName())) {
            builder.field("analyzer", field.analyzerName().toString().toLowerCase());
        }
        if (field.indexAnalyzerName() != null && !"default-analyzer".equals(field.indexAnalyzerName())) {
            builder.field("index_analyzer", field.indexAnalyzerName().toString().toLowerCase());
        }
        if (field.searchAnalyzerName() != null && !"default-analyzer".equals(field.searchAnalyzerName())) {
            builder.field("search_analyzer", field.searchAnalyzerName().toString().toLowerCase());
        }
        if (field.termVector() != null && !ElasticsearchMappingField.TermVector.No.equals((Object)field.termVector())) {
            builder.field("term_vector", field.termVector().toString().toLowerCase());
        }
        if (field.fields().length != 0) {
            ElasticsearchMappingField.ElasticsearchMappingSubField[] fields = field.fields();
            if (fields != null && fields.length > 0) {
                builder = builder.startObject("fields");
                for (ElasticsearchMappingField.ElasticsearchMappingSubField subField : fields) {
                    builder = this.buildField(subField, builder);
                }
                builder = builder.endObject();
            }
            builder = builder.endObject();
        }
        builder = builder.endObject();
        return builder;
    }

    private XContentBuilder buildField(ElasticsearchMappingField.ElasticsearchMappingSubField field, XContentBuilder builder) throws IOException {
        builder = builder.startObject(field.name()).field("type", field.type().toString().toLowerCase()).field("store", field.store().toString().toLowerCase());
        if (!field.index().equals((Object)ElasticsearchMappingField.Index.Undefined)) {
            builder.field("index", field.index().toString().toLowerCase());
        }
        if (field.analyzerName() != null && !"default-analyzer".equals(field.analyzerName())) {
            builder.field("analyzer", field.analyzerName().toString().toLowerCase());
        }
        if (field.indexAnalyzerName() != null && !"default-analyzer".equals(field.indexAnalyzerName())) {
            builder.field("index_analyzer", field.indexAnalyzerName().toString().toLowerCase());
        }
        if (field.searchAnalyzerName() != null && !"default-analyzer".equals(field.searchAnalyzerName())) {
            builder.field("search_analyzer", field.searchAnalyzerName().toString().toLowerCase());
        }
        if (field.termVector() != null && !ElasticsearchMappingField.TermVector.No.equals((Object)field.termVector())) {
            builder.field("term_vector", field.termVector().toString().toLowerCase());
        }
        builder = builder.endObject();
        return builder;
    }

    private XContentBuilder buildMapping(ElasticsearchMapping mapping) throws IOException {
        XContentBuilder builder = null;
        try {
            builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).startObject().startObject(mapping.typeName()).startObject("_source").field("enabled", String.valueOf(mapping.source()));
            if (!mapping.compress()) {
                builder.field("compress", String.valueOf(mapping.compress()));
            } else {
                builder.field("compress", String.valueOf(mapping.compress()));
                if (!"".equals(mapping.compressThreshold())) {
                    builder.field("compress_threshold", mapping.compressThreshold());
                }
            }
            builder.endObject();
            if (!"".equals(mapping.parent())) {
                builder = builder.startObject("_parent").field("type", mapping.parent()).endObject();
            }
            if (mapping.ttl()) {
                builder = builder.startObject("_ttl").field("enabled", String.valueOf(mapping.ttl()));
                if (mapping.ttlValue().length() > 0) {
                    builder = builder.field("default", mapping.ttlValue());
                }
                builder = builder.endObject();
            }
            if (mapping.timestamp()) {
                builder = builder.startObject("_timestamp").field("enabled", String.valueOf(mapping.timestamp()));
                if (mapping.timestampPath().length() > 0) {
                    builder = builder.field("path", mapping.timestampPath());
                }
                if (mapping.timestampFormat().length() > 0) {
                    builder = builder.field("format", mapping.timestampFormat());
                }
                builder = builder.endObject();
            }
            builder = builder.startObject("properties");
            ElasticsearchMappingField[] properties = mapping.properties();
            if (properties != null && properties.length > 0) {
                for (ElasticsearchMappingField field : properties) {
                    builder = this.buildField(field, builder);
                }
            }
            builder.endObject().endObject().endObject();
            LOGGER.info(String.format("Mapping [%s]:\r\n%s\r\n", mapping.typeName(), builder.string()));
        }
        catch (Exception e) {
            LOGGER.severe("Exception when building mapping for type " + mapping.typeName() + ": " + e.getMessage());
        }
        return builder;
    }
}

