/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations;

import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchNode;
import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchSetting;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.ClassLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.FieldLevelElasticsearchAnnotationHandler;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ElasticsearchNodeAnnotationHandler
implements ClassLevelElasticsearchAnnotationHandler,
FieldLevelElasticsearchAnnotationHandler {
    private static final String ES_HOME = "./target/elasticsearch-test";
    private static final String NODE_NAME = "node.name";

    @Override
    public boolean support(Annotation annotation) {
        return annotation instanceof ElasticsearchNode;
    }

    @Override
    public void beforeClass(Object testClass, Map<String, Object> context) throws Exception {
    }

    @Override
    public void handleBeforeClass(Annotation annotation, Object testClass, Map<String, Object> context) {
        this.buildNode((ElasticsearchNode)annotation, context);
    }

    @Override
    public void handleAfterClass(Annotation annotation, Object testClass, Map<String, Object> context) {
    }

    @Override
    public void afterClass(Object testClass, Map<String, Object> context) throws Exception {
        for (Object obj : context.values()) {
            Node node;
            if (!(obj instanceof Node) || (node = (Node)obj).isClosed()) continue;
            node.close();
        }
        FileSystemUtils.deleteRecursively((File)new File(ES_HOME));
    }

    @Override
    public void handleField(Annotation annotation, Object instance, Map<String, Object> context, Field field) throws Exception {
        Node node = this.buildNode((ElasticsearchNode)annotation, context);
        try {
            field.setAccessible(true);
            field.set(instance, node);
        }
        catch (Exception e) {
            throw new Exception("Exception when setting the node:" + e.getMessage(), e);
        }
    }

    private Node buildNode(ElasticsearchNode elasticsearchNode, Map<String, Object> context) {
        Settings settings = this.buildNodeSettings(elasticsearchNode);
        String nodeName = settings.get(NODE_NAME);
        Node node = (Node)context.get(nodeName);
        if (node == null) {
            node = NodeBuilder.nodeBuilder().settings(settings).local(elasticsearchNode.local()).node();
            context.put(nodeName, node);
        }
        return node;
    }

    private Settings buildNodeSettings(ElasticsearchNode elasticsearchNode) {
        ElasticsearchSetting[] settings;
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(NODE_NAME, elasticsearchNode.name()).put("node.data", elasticsearchNode.data()).put("cluster.name", elasticsearchNode.clusterName()).put("index.store.type", "memory").put("index.store.fs.memory.enabled", "true").put("gateway.type", "none").put("path.data", "./target/elasticsearch-test/data").put("path.work", "./target/elasticsearch-test/work").put("path.logs", "./target/elasticsearch-test/logs").put("index.number_of_shards", "1").put("index.number_of_replicas", "0");
        Settings configSettings = ImmutableSettings.settingsBuilder().loadFromClasspath(elasticsearchNode.configFile()).build();
        settingsBuilder.put(configSettings);
        for (ElasticsearchSetting setting : settings = elasticsearchNode.settings()) {
            settingsBuilder.put(setting.name(), setting.value());
        }
        return settingsBuilder.build();
    }
}

