/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.rules;

import com.github.tlrx.elasticsearch.test.support.junit.handlers.ElasticsearchAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AbstractElasticsearchRule
implements TestRule {
    protected List<ElasticsearchAnnotationHandler> handlers = new ArrayList<ElasticsearchAnnotationHandler>();
    protected final Map<String, Object> context;

    public AbstractElasticsearchRule(Map<String, Object> context) {
        this.context = context;
    }

    public boolean addHandler(ElasticsearchAnnotationHandler handler) {
        return this.handlers.add(handler);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    AbstractElasticsearchRule.this.before(description.getAnnotations());
                    base.evaluate();
                }
                finally {
                    AbstractElasticsearchRule.this.after(description.getAnnotations());
                }
            }
        };
    }

    protected void before(Collection<Annotation> annotations) throws Exception {
    }

    protected void after(Collection<Annotation> annotations) throws Exception {
    }

    protected List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type != null) {
            for (Field field : type.getDeclaredFields()) {
                fields.add(field);
            }
            if (type.getSuperclass() != null) {
                fields.addAll(this.getAllFields(type.getSuperclass()));
            }
        }
        return fields;
    }
}

