/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit5;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.JvmProxyConfigurer;
import com.github.tomakehurst.wiremock.junit.DslWrapper;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class WireMockExtension
extends DslWrapper
implements ParameterResolver,
BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Options DEFAULT_OPTIONS = WireMockConfiguration.options().dynamicPort();
    private final boolean configureStaticDsl;
    private final boolean failOnUnmatchedRequests;
    private Options options;
    private WireMockServer wireMockServer;
    private boolean isNonStatic = false;
    private Boolean proxyMode;

    public WireMockExtension() {
        this.configureStaticDsl = true;
        this.failOnUnmatchedRequests = false;
    }

    protected WireMockExtension(Options options, boolean configureStaticDsl, boolean failOnUnmatchedRequests, boolean proxyMode) {
        this.options = options;
        this.configureStaticDsl = configureStaticDsl;
        this.failOnUnmatchedRequests = failOnUnmatchedRequests;
        this.proxyMode = proxyMode;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.parameterIsWireMockRuntimeInfo(parameterContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.parameterIsWireMockRuntimeInfo(parameterContext)) {
            return new WireMockRuntimeInfo(this.wireMockServer);
        }
        return null;
    }

    private void startServerIfRequired(ExtensionContext extensionContext) {
        if (this.wireMockServer == null) {
            this.wireMockServer = new WireMockServer(this.resolveOptions(extensionContext));
            this.wireMockServer.start();
            this.admin = this.wireMockServer;
            this.stubbing = this.wireMockServer;
            if (this.configureStaticDsl) {
                WireMock.configureFor(new WireMock(this));
            }
        }
    }

    private void setAdditionalOptions(ExtensionContext extensionContext) {
        if (this.proxyMode == null) {
            this.proxyMode = extensionContext.getElement().flatMap(annotatedElement -> AnnotationSupport.findAnnotation((AnnotatedElement)annotatedElement, WireMockTest.class)).map(WireMockTest::proxyMode).orElse(false);
        }
    }

    private Options resolveOptions(ExtensionContext extensionContext) {
        return extensionContext.getElement().flatMap(annotatedElement -> AnnotationSupport.findAnnotation((AnnotatedElement)annotatedElement, WireMockTest.class)).map(this::buildOptionsFromWireMockTestAnnotation).orElse(Optional.ofNullable(this.options).orElse(DEFAULT_OPTIONS));
    }

    private Options buildOptionsFromWireMockTestAnnotation(WireMockTest annotation) {
        WireMockConfiguration options = WireMockConfiguration.options().port(annotation.httpPort()).enableBrowserProxying(annotation.proxyMode());
        if (annotation.httpsEnabled()) {
            options.httpsPort(annotation.httpsPort());
        }
        return options;
    }

    private void stopServerIfRunning() {
        if (this.wireMockServer.isRunning()) {
            this.wireMockServer.stop();
        }
    }

    private boolean parameterIsWireMockRuntimeInfo(ParameterContext parameterContext) {
        return parameterContext.getParameter().getType().equals(WireMockRuntimeInfo.class);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.startServerIfRequired(context);
        this.setAdditionalOptions(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.wireMockServer == null) {
            this.isNonStatic = true;
            this.startServerIfRequired(context);
        } else {
            this.resetToDefaultMappings();
        }
        this.setAdditionalOptions(context);
        if (this.proxyMode.booleanValue()) {
            JvmProxyConfigurer.configureFor(this.wireMockServer);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.stopServerIfRunning();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.failOnUnmatchedRequests) {
            this.wireMockServer.checkForUnmatchedRequests();
        }
        if (this.isNonStatic) {
            this.stopServerIfRunning();
        }
        if (this.proxyMode.booleanValue()) {
            JvmProxyConfigurer.restorePrevious();
        }
    }

    public WireMockRuntimeInfo getRuntimeInfo() {
        return new WireMockRuntimeInfo(this.wireMockServer);
    }

    public String baseUrl() {
        return this.wireMockServer.baseUrl();
    }

    public static class Builder {
        private Options options = WireMockConfiguration.wireMockConfig().dynamicPort();
        private boolean configureStaticDsl = false;
        private boolean failOnUnmatchedRequests = false;
        private boolean proxyMode = false;

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder configureStaticDsl(boolean configureStaticDsl) {
            this.configureStaticDsl = configureStaticDsl;
            return this;
        }

        public Builder failOnUnmatchedRequests(boolean failOnUnmatched) {
            this.failOnUnmatchedRequests = failOnUnmatched;
            return this;
        }

        public Builder proxyMode(boolean proxyMode) {
            this.proxyMode = proxyMode;
            return this;
        }

        public WireMockExtension build() {
            if (this.proxyMode && !this.options.browserProxySettings().enabled() && this.options instanceof WireMockConfiguration) {
                ((WireMockConfiguration)this.options).enableBrowserProxying(true);
            }
            return new WireMockExtension(this.options, this.configureStaticDsl, this.failOnUnmatchedRequests, this.proxyMode);
        }
    }
}

