/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.http.BadMessageException;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpGenerator;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpHeaderValue;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http.PreEncodedHttpField;
import wiremock.org.eclipse.jetty.http2.IStream;
import wiremock.org.eclipse.jetty.http2.frames.DataFrame;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.WriteFlusher;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpChannel;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpInput;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.thread.Invocable;

public class HttpChannelOverHTTP2
extends HttpChannel
implements Closeable,
WriteFlusher.Listener {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHTTP2.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private boolean _expect100Continue;
    private boolean _delayedUntilContent;

    public HttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
        super(connector, configuration, endPoint, transport);
    }

    protected IStream getStream() {
        return this.getHttpTransport().getStream();
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public void setIdleTimeout(long timeoutMs) {
        this.getStream().setIdleTimeout(timeoutMs);
    }

    @Override
    public long getIdleTimeout() {
        return this.getStream().getIdleTimeout();
    }

    @Override
    public void onFlushed(long bytes) throws IOException {
        this.getResponse().getHttpOutput().onFlushed(bytes);
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            String authority;
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpFields fields = request.getFields();
            if (!fields.contains(HttpHeader.HOST) && (authority = request.getURI().getAuthority()) != null) {
                fields.put("host", authority);
            }
            this._expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            HttpFields response = this.getResponse().getHttpFields();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                response.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                response.add(POWERED_BY);
            }
            this.onRequest(request);
            boolean endStream = frame.isEndStream();
            if (endStream) {
                this.onContentComplete();
                this.onRequestComplete();
            }
            boolean bl = this._delayedUntilContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && !endStream && !this._expect100Continue;
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 Request #{}/{}, delayed={}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), this._delayedUntilContent, System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), fields});
            }
            return this._delayedUntilContent ? null : this;
        }
        catch (BadMessageException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequest", x);
            }
            return () -> this.onBadMessage(x);
        }
        catch (Throwable x) {
            return () -> this.onBadMessage(new BadMessageException(500, null, x));
        }
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this.onRequest(request);
            this.getRequest().setAttribute("wiremock.org.eclipse.jetty.pushed", Boolean.TRUE);
            this.onContentComplete();
            this.onRequestComplete();
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 PUSH Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
            }
            return this;
        }
        catch (BadMessageException x) {
            return () -> this.onBadMessage(x);
        }
        catch (Throwable x) {
            return () -> this.onBadMessage(new BadMessageException(500, null, x));
        }
    }

    @Override
    public HttpTransportOverHTTP2 getHttpTransport() {
        return (HttpTransportOverHTTP2)super.getHttpTransport();
    }

    @Override
    public void recycle() {
        this._expect100Continue = false;
        this._delayedUntilContent = false;
        super.recycle();
        this.getHttpTransport().recycle();
    }

    @Override
    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Commit Response #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), info.getHttpVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    public Runnable onRequestContent(DataFrame frame, final Callback callback) {
        IStream stream = this.getStream();
        if (stream.isReset()) {
            this.consumeInput();
            callback.succeeded();
            return null;
        }
        ByteBuffer buffer = frame.getData();
        int length = buffer.remaining();
        boolean handle = this.onContent(new HttpInput.Content(buffer){

            @Override
            public void succeeded() {
                callback.succeeded();
            }

            @Override
            public void failed(Throwable x) {
                callback.failed(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return callback.getInvocationType();
            }
        });
        boolean endStream = frame.isEndStream();
        if (endStream) {
            boolean handleContent = this.onContentComplete();
            boolean handleRequest = this.onRequestComplete();
            handle |= handleContent | handleRequest;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: {} bytes of {} content, handle: {}", stream.getId(), Integer.toHexString(stream.getSession().hashCode()), length, endStream ? "last" : "some", handle);
        }
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    public Runnable onRequestTrailers(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields();
        if (trailers.size() > 0) {
            this.onTrailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}, trailers:{}{}", stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), trailers);
        }
        boolean handle = this.onRequestComplete();
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        return handle || wasDelayed ? this : null;
    }

    public boolean isRequestIdle() {
        return this.getState().isIdle();
    }

    public boolean onStreamTimeout(Throwable failure, Consumer<Runnable> consumer) {
        boolean delayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        boolean result = this.isRequestIdle();
        if (result) {
            this.consumeInput();
        }
        this.getHttpTransport().onStreamTimeout(failure);
        if (this.getRequest().getHttpInput().onIdleTimeout(failure) || delayed) {
            consumer.accept(this::handleWithContext);
            result = false;
        }
        return result;
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        this.getHttpTransport().onStreamFailure(failure);
        boolean handle = this.getRequest().getHttpInput().failed(failure);
        this.consumeInput();
        return new FailureTask(failure, callback, handle);
    }

    protected void consumeInput() {
        this.getRequest().getHttpInput().consumeAll();
    }

    private void handleWithContext() {
        ContextHandler context = this.getState().getContextHandler();
        if (context != null) {
            context.handle(this.getRequest(), this);
        } else {
            this.handle();
        }
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    @Override
    public void close() {
        this.abort(new IOException("Unexpected close"));
    }

    @Override
    public String toString() {
        IStream stream = this.getStream();
        long streamId = stream == null ? -1L : (long)stream.getId();
        return String.format("%s#%d", super.toString(), streamId);
    }

    private class FailureTask
    implements Runnable {
        private final Throwable failure;
        private final Callback callback;
        private final boolean handle;

        public FailureTask(Throwable failure, Callback callback, boolean handle) {
            this.failure = failure;
            this.callback = callback;
            this.handle = handle;
        }

        @Override
        public void run() {
            try {
                if (this.handle) {
                    HttpChannelOverHTTP2.this.handleWithContext();
                } else if (HttpChannelOverHTTP2.this.getHttpConfiguration().isNotifyRemoteAsyncErrors()) {
                    HttpChannelOverHTTP2.this.getState().asyncError(this.failure);
                }
                this.callback.succeeded();
            }
            catch (Throwable x) {
                this.callback.failed(x);
            }
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getName(), this.hashCode(), this.failure);
        }
    }
}

