/**
 * Copyright 2019 Anthony Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.LifeCycle;


public interface Appender<E> extends LifeCycle, ContextAware, FilterAttachable<E> {

  /**
   * Get the name of this appender. The name uniquely identifies the appender.
   * @return the appender's name
   */
  String getName();

  /**
   * This is where an appender accomplishes its work. Note that the argument
   * is of type Object.
   * @param event the log event
   */
  void doAppend(E event) throws LogbackException;

  /**
   * Set the name of this appender. The name is used by other components to
   * identify this appender.
   * @param name desired appender name
   */
  void setName(String name);

}
