/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptmavenplugin.mojo;

import com.ulisesbocchio.jasyptmavenplugin.encrypt.EncryptionService;
import com.ulisesbocchio.jasyptmavenplugin.mojo.AbstractValueJasyptMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="decrypt-value", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=false)
public class DecryptValueMojo
extends AbstractValueJasyptMojo {
    private static final Logger log = LoggerFactory.getLogger(DecryptValueMojo.class);

    @Override
    protected void run(EncryptionService service, String value, String encryptPrefix, String encryptSuffix, String decryptPrefix, String decryptSuffix) throws MojoExecutionException {
        try {
            String actualValue = value.startsWith(encryptPrefix) ? value.substring(encryptPrefix.length(), value.length() - encryptSuffix.length()) : value;
            log.info("Decrypting value " + actualValue);
            String decryptedValue = service.decryptValue(actualValue);
            log.info("\n" + decryptedValue);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Decrypting: " + e.getMessage(), e);
        }
    }
}

