/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.filter;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.filter.DefaultPropertyFilter;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.PropertySource;

public class DefaultLazyPropertyFilter
implements EncryptablePropertyFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyPropertyFilter.class);
    private static final List<String> DEFAULT_FILTER_EXCLUDE_PATTERNS = Collections.singletonList("^jasypt\\.encryptor\\.*");
    private Singleton<EncryptablePropertyFilter> singleton = new Singleton<EncryptablePropertyFilter>(() -> Optional.of(customFilterBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (EncryptablePropertyFilter)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Filter Bean {} with name: {}", bean, (Object)customFilterBeanName))).orElseGet(() -> {
        if (isCustom) {
            throw new IllegalStateException(String.format("Property Filter custom Bean not found with name '%s'", customFilterBeanName));
        }
        List<String> actualExcludeNames = com.ulisesbocchio.jasyptspringboot.util.Collections.concat(Optional.ofNullable(excludeNames).orElseGet(ArrayList::new), DEFAULT_FILTER_EXCLUDE_PATTERNS);
        log.info("Property Filter custom Bean not found with name '{}'. Initializing Default Property Filter", (Object)customFilterBeanName);
        return new DefaultPropertyFilter(includeSources, excludeSources, includeNames, actualExcludeNames);
    }));

    public DefaultLazyPropertyFilter(List<String> includeSources, List<String> excludeSources, List<String> includeNames, List<String> excludeNames, String customFilterBeanName, boolean isCustom, BeanFactory bf) {
    }

    @Override
    public boolean shouldInclude(PropertySource<?> source, String name) {
        return this.singleton.get().shouldInclude(source, name);
    }
}

