/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import org.eclipse.osgi.framework.internal.reliablefile.ReliableFile;

public class ReliableFileInputStream
extends FilterInputStream {
    private ReliableFile reliable;
    private int sigSize;
    private long readPos;
    private long length;

    public ReliableFileInputStream(String name) throws IOException {
        this(ReliableFile.getReliableFile(name), 0, 0);
    }

    public ReliableFileInputStream(File file) throws IOException {
        this(ReliableFile.getReliableFile(file), 0, 0);
    }

    public ReliableFileInputStream(File file, int generation, int openMask) throws IOException {
        this(ReliableFile.getReliableFile(file), generation, openMask);
    }

    private ReliableFileInputStream(ReliableFile reliable, int generation, int openMask) throws IOException {
        super(reliable.getInputStream(generation, openMask));
        this.reliable = reliable;
        this.sigSize = reliable.getSignatureSize();
        this.readPos = 0L;
        this.length = reliable.getInputLength();
        this.length = (long)this.sigSize > this.length ? 0L : (this.length -= (long)this.sigSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.reliable != null) {
            try {
                super.close();
            }
            finally {
                this.reliable.closeInputFile();
                this.reliable = null;
            }
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.readPos >= this.length) {
            return -1;
        }
        int num = super.read(b, off, len);
        if (num != -1) {
            if ((long)num + this.readPos > this.length) {
                num = (int)(this.length - this.readPos);
            }
            this.readPos += (long)num;
        }
        return num;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.readPos >= this.length) {
            return -1;
        }
        int num = super.read();
        if (num != -1) {
            ++this.readPos;
        }
        return num;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.readPos < this.length) {
            return (int)(this.length - this.readPos);
        }
        return 0;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long len = super.skip(n);
        if (this.readPos + len > this.length) {
            len = this.length - this.readPos;
        }
        this.readPos += len;
        return len;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported.");
    }
}

