/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.internal.debug.EclipseDebugTrace;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer<DebugOptionsListener, DebugOptionsListener> {
    private static final String OSGI_DEBUG = "osgi.debug";
    private static final String OSGI_DEBUG_VERBOSE = "osgi.debug.verbose";
    public static final String PROP_TRACEFILE = "osgi.tracefile";
    private static final String OPTIONS = ".options";
    private static final Object writeLock = new Object();
    private final Object lock = new Object();
    private Properties options = null;
    private Properties disabledOptions = null;
    protected final Map<String, DebugTrace> debugTraceCache = new HashMap<String, DebugTrace>();
    protected File outFile = null;
    protected boolean verboseDebug = true;
    private boolean newSession = true;
    private final EquinoxConfiguration environmentInfo;
    private volatile BundleContext context;
    private volatile ServiceTracker<DebugOptionsListener, DebugOptionsListener> listenerTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkDebugOptions(EquinoxConfiguration environmentInfo) {
        URL optionsFile;
        this.environmentInfo = environmentInfo;
        this.verboseDebug = Boolean.valueOf(environmentInfo.getConfiguration(OSGI_DEBUG_VERBOSE, Boolean.TRUE.toString()));
        String debugOptionsFilename = environmentInfo.getConfiguration(OSGI_DEBUG);
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = userDir + "/";
            }
            debugOptionsFilename = new File(userDir, OPTIONS).toString();
        }
        if ((optionsFile = FrameworkDebugOptions.buildURL(debugOptionsFilename, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            return;
        }
        System.out.print("Debug options:\n    " + optionsFile.toExternalForm());
        try (InputStream input = optionsFile.openStream();){
            this.options.load(input);
            System.out.println(" loaded");
        }
        catch (FileNotFoundException e) {
            System.out.println(" not found");
        }
        catch (IOException e) {
            System.out.println(" did not parse");
            e.printStackTrace(System.out);
        }
        for (Object key : this.options.keySet()) {
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
    }

    public void start(BundleContext bc) {
        this.context = bc;
        this.listenerTracker = new ServiceTracker(bc, DebugOptionsListener.class.getName(), (ServiceTrackerCustomizer)this);
        this.listenerTracker.open();
    }

    public void stop(BundleContext bc) {
        this.listenerTracker.close();
        this.listenerTracker = null;
        this.context = null;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            if (isFile) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? file + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    @Override
    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null ? optionValue.equalsIgnoreCase("true") : defaultValue;
    }

    @Override
    public String getOption(String option) {
        return this.getOption(option, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOption(String option, String defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                return this.options.getProperty(option, defaultValue);
            }
        }
        return defaultValue;
    }

    @Override
    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> snapShot = new HashMap<String, String>();
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                snapShot.putAll(this.options);
            } else if (this.disabledOptions != null) {
                snapShot.putAll(this.disabledOptions);
            }
        }
        return snapShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAllOptions() {
        String[] optionsArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                optionsArray = new String[this.options.size()];
                Iterator<Map.Entry<Object, Object>> entrySetIterator = this.options.entrySet().iterator();
                int i = 0;
                while (entrySetIterator.hasNext()) {
                    Map.Entry<Object, Object> entry = entrySetIterator.next();
                    optionsArray[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
                    ++i;
                }
            }
        }
        if (optionsArray == null) {
            optionsArray = new String[1];
        }
        return optionsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOption(String option) {
        if (option == null) {
            return;
        }
        String fireChangedEvent = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null && this.options.remove(option) != null) {
                fireChangedEvent = this.getSymbolicName(option);
            }
        }
        if (fireChangedEvent != null) {
            this.optionsChanged(fireChangedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String option, String value) {
        if (option == null || value == null) {
            throw new IllegalArgumentException("The option and value must not be null.");
        }
        String fireChangedEvent = null;
        value = value != null ? value.trim() : null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                String currentValue = this.options.getProperty(option);
                if (currentValue != null) {
                    if (!currentValue.equals(value)) {
                        fireChangedEvent = this.getSymbolicName(option);
                    }
                } else if (value != null) {
                    fireChangedEvent = this.getSymbolicName(option);
                }
                if (fireChangedEvent != null) {
                    this.options.put(option, value);
                }
            }
        }
        if (fireChangedEvent != null) {
            this.optionsChanged(fireChangedEvent);
        }
    }

    private String getSymbolicName(String option) {
        int firstSlashIndex = option.indexOf("/");
        if (firstSlashIndex > 0) {
            return option.substring(0, firstSlashIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOptions(Map<String, String> ops) {
        Map.Entry<String, String> entry22;
        if (ops == null) {
            throw new IllegalArgumentException("The options must not be null.");
        }
        Properties newOptions = new Properties();
        for (Map.Entry<String, String> entry22 : ops.entrySet()) {
            if (!(entry22.getKey() instanceof String) || !(entry22.getValue() instanceof String)) {
                throw new IllegalArgumentException("Option keys and values must be of type String: " + (String)entry22.getKey() + "=" + (String)entry22.getValue());
            }
            newOptions.put(entry22.getKey(), ((String)entry22.getValue()).trim());
        }
        HashSet<String> fireChangesTo = null;
        entry22 = this.lock;
        synchronized (entry22) {
            if (this.options == null) {
                this.disabledOptions = newOptions;
                return;
            }
            fireChangesTo = new HashSet<String>();
            for (String string : this.options.keySet()) {
                String symbolicName;
                if (newOptions.containsKey(string) || (symbolicName = this.getSymbolicName(string)) == null) continue;
                fireChangesTo.add(symbolicName);
            }
            for (Map.Entry<Object, Object> entry : newOptions.entrySet()) {
                String symbolicName;
                String existingValue = (String)this.options.get(entry.getKey());
                if (entry.getValue().equals(existingValue) || (symbolicName = this.getSymbolicName((String)entry.getKey())) == null) continue;
                fireChangesTo.add(symbolicName);
            }
            this.options = newOptions;
        }
        if (fireChangesTo != null) {
            Iterator iChanges = fireChangesTo.iterator();
            while (iChanges.hasNext()) {
                this.optionsChanged((String)iChanges.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebugEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.options != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugEnabled(boolean enabled) {
        boolean fireChangedEvent = false;
        Object object = this.lock;
        synchronized (object) {
            if (enabled) {
                if (this.options != null) {
                    return;
                }
                this.newSession = true;
                this.environmentInfo.setConfiguration(OSGI_DEBUG, "");
                if (this.disabledOptions != null) {
                    this.options = this.disabledOptions;
                    this.disabledOptions = null;
                    fireChangedEvent = true;
                } else {
                    this.options = new Properties();
                }
            } else {
                if (this.options == null) {
                    return;
                }
                this.environmentInfo.clearConfiguration(OSGI_DEBUG);
                if (this.options.size() > 0) {
                    this.disabledOptions = this.options;
                    fireChangedEvent = true;
                }
                this.options = null;
            }
        }
        if (fireChangedEvent) {
            this.optionsChanged("*");
        }
    }

    @Override
    public final DebugTrace newDebugTrace(String bundleSymbolicName) {
        return this.newDebugTrace(bundleSymbolicName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DebugTrace newDebugTrace(String bundleSymbolicName, Class<?> traceEntryClass) {
        DebugTrace debugTrace = null;
        Map<String, DebugTrace> map = this.debugTraceCache;
        synchronized (map) {
            debugTrace = this.debugTraceCache.get(bundleSymbolicName);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(bundleSymbolicName, this, traceEntryClass);
                this.debugTraceCache.put(bundleSymbolicName, debugTrace);
            }
        }
        return debugTrace;
    }

    @Override
    public final File getFile() {
        return this.outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File traceFile) {
        Object object = this.lock;
        synchronized (object) {
            this.outFile = traceFile;
            if (this.outFile != null) {
                this.environmentInfo.setConfiguration(PROP_TRACEFILE, this.outFile.getAbsolutePath());
            } else {
                this.environmentInfo.clearConfiguration(PROP_TRACEFILE);
            }
            this.newSession = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean newSession() {
        Object object = this.lock;
        synchronized (object) {
            if (this.newSession) {
                this.newSession = false;
                return true;
            }
            return false;
        }
    }

    Object getWriteLock() {
        return writeLock;
    }

    boolean isVerbose() {
        return this.verboseDebug;
    }

    EquinoxConfiguration getConfiguration() {
        return this.environmentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerbose(boolean verbose) {
        Object object = this.lock;
        synchronized (object) {
            this.verboseDebug = verbose;
            this.newSession = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optionsChanged(String bundleSymbolicName) {
        BundleContext bc = this.context;
        if (bc == null) {
            return;
        }
        ServiceReference[] listenerRefs = null;
        try {
            listenerRefs = bc.getServiceReferences(DebugOptionsListener.class.getName(), "(listener.symbolic.name=" + bundleSymbolicName + ")");
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (listenerRefs == null) {
            return;
        }
        for (int i = 0; i < listenerRefs.length; ++i) {
            DebugOptionsListener service = (DebugOptionsListener)bc.getService((ServiceReference)listenerRefs[i]);
            if (service == null) continue;
            try {
                service.optionsChanged(this);
                continue;
            }
            catch (Throwable t) {
                continue;
            }
            finally {
                bc.ungetService(listenerRefs[i]);
            }
        }
    }

    public DebugOptionsListener addingService(ServiceReference<DebugOptionsListener> reference) {
        DebugOptionsListener listener = (DebugOptionsListener)this.context.getService(reference);
        listener.optionsChanged(this);
        return listener;
    }

    public void modifiedService(ServiceReference<DebugOptionsListener> reference, DebugOptionsListener service) {
    }

    public void removedService(ServiceReference<DebugOptionsListener> reference, DebugOptionsListener service) {
        this.context.ungetService(reference);
    }
}

