/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.ContextFinder;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ServiceObjectsImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.resource.Capability;

public class BundleContextImpl
implements BundleContext,
EventDispatcher<Object, Object, Object> {
    static final String findHookName = FindHook.class.getName();
    private volatile boolean valid;
    final EquinoxBundle bundle;
    final EquinoxContainer container;
    final Debug debug;
    private HashMap<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse;
    private BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleContextImpl(EquinoxBundle bundle, EquinoxContainer container) {
        this.bundle = bundle;
        this.container = container;
        this.debug = container.getConfiguration().getDebug();
        this.valid = true;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry registry = this.container.getServiceRegistry();
        registry.removeAllServiceListeners(this);
        this.container.getEventPublisher().removeAllListeners(this);
        registry.unregisterServices(this);
        registry.releaseServicesInUse(this);
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.container.getConfiguration().getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.getBundleImpl();
    }

    public EquinoxBundle getBundleImpl() {
        return this.bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.checkValid();
        try {
            URLConnection content = this.container.getStorage().getContentConnection(null, location, in);
            BundleInfo.Generation generation = this.container.getStorage().install(this.bundle.getModule(), location, content);
            return generation.getRevision().getBundle();
        }
        catch (IOException e) {
            throw new BundleException("Error reading bundle content.", (Throwable)e);
        }
    }

    public Bundle getBundle(long id) {
        Module m = this.container.getStorage().getModuleContainer().getModule(id);
        if (m == null) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(1);
        bundles.add(m.getBundle());
        this.notifyFindHooks(this, bundles);
        if (bundles.isEmpty()) {
            return null;
        }
        return m.getBundle();
    }

    public Bundle getBundle(String location) {
        Module m = this.container.getStorage().getModuleContainer().getModule(location);
        return m == null ? null : m.getBundle();
    }

    public Bundle[] getBundles() {
        List<Module> modules = this.container.getStorage().getModuleContainer().getModules();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(modules.size());
        for (Module module : modules) {
            bundles.add(module.getBundle());
        }
        this.notifyFindHooks(this, bundles);
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    private void notifyFindHooks(final BundleContextImpl context, List<Bundle> allBundles) {
        if (context.getBundleImpl().getBundleId() == 0L) {
            allBundles = new ArrayList<Bundle>(allBundles);
        }
        final ShrinkableCollection<Bundle> shrinkable = new ShrinkableCollection<Bundle>((Collection<Bundle>)allBundles);
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPriviledged(context, shrinkable);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    BundleContextImpl.this.notifyFindHooksPriviledged(context, shrinkable);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPriviledged(final BundleContextImpl context, final Collection<Bundle> allBundles) {
        if (this.debug.DEBUG_HOOKS) {
            Debug.println("notifyBundleFindHooks(" + allBundles + ")");
        }
        this.container.getServiceRegistry().notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof FindHook) {
                    ((FindHook)hook).find((BundleContext)context, allBundles);
                }
            }

            @Override
            public String getHookClassName() {
                return findHookName;
            }

            @Override
            public String getHookMethodName() {
                return "find";
            }
        });
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.container.getServiceRegistry().addServiceListener(this, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        block2: {
            try {
                this.addServiceListener(listener, null);
            }
            catch (InvalidSyntaxException e) {
                if (!this.debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + e.getMessage());
                Debug.printStackTrace(e);
            }
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.container.getServiceRegistry().removeServiceListener(this, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().addBundleListener(listener, this);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().removeBundleListener(listener, this);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().addFrameworkListener(listener, this);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().removeFrameworkListener(listener, this);
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.checkValid();
        return this.container.getServiceRegistry().registerService(this, clazzes, service, properties);
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReferences(this, clazz, filter, false);
    }

    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReferences(this, clazz, filter, true);
    }

    public ServiceReference<?> getServiceReference(String clazz) {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReference(this, clazz);
    }

    public <S> S getService(ServiceReference<S> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        this.provisionServicesInUseMap();
        Object service = this.container.getServiceRegistry().getService(this, (ServiceReferenceImpl)reference);
        return service;
    }

    public boolean ungetService(ServiceReference<?> reference) {
        this.checkValid();
        return this.container.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)reference);
    }

    public File getDataFile(String filename) {
        this.checkValid();
        BundleInfo.Generation generation = (BundleInfo.Generation)this.bundle.getModule().getCurrentRevision().getRevisionInfo();
        return generation.getBundleInfo().getDataFile(filename);
    }

    protected void start() throws BundleException {
        try {
            this.activator = this.loadBundleActivator();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BundleException(Msg.BundleContextImpl_LoadActivatorError, 5, (Throwable)e);
        }
        if (this.activator != null) {
            long start = 0L;
            if (this.debug.DEBUG_BUNDLE_TIME) {
                start = System.currentTimeMillis();
                Debug.println("Starting " + this.bundle);
            }
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException be) {
                this.activator = null;
                throw be;
            }
            finally {
                if (this.debug.DEBUG_BUNDLE_TIME) {
                    Debug.println("End starting " + this.bundle + " " + (System.currentTimeMillis() - start));
                }
            }
        }
    }

    private BundleActivator loadBundleActivator() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ModuleWiring wiring = this.bundle.getModule().getCurrentRevision().getWiring();
        if (wiring == null) {
            return null;
        }
        BundleLoader loader = (BundleLoader)wiring.getModuleLoader();
        if (loader == null) {
            return null;
        }
        List<Capability> metadata = wiring.getRevision().getCapabilities("equinox.module.data");
        if (metadata.isEmpty()) {
            return null;
        }
        String activatorName = (String)metadata.get(0).getAttributes().get("activator");
        if (activatorName == null) {
            return null;
        }
        Class<?> activatorClass = loader.findClass(activatorName);
        return (BundleActivator)activatorClass.newInstance();
    }

    private void startActivator(final BundleActivator bundleActivator) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (bundleActivator != null) {
                        Object previousTCCL = BundleContextImpl.this.setContextFinder();
                        try {
                            bundleActivator.start((BundleContext)BundleContextImpl.this);
                        }
                        finally {
                            if (previousTCCL != Boolean.FALSE) {
                                Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (this.debug.DEBUG_GENERAL) {
                Debug.printStackTrace(t2);
            }
            String clazz = null;
            clazz = bundleActivator.getClass().getName();
            throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "start", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, (Throwable)t2);
        }
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        if (!this.container.getConfiguration().BUNDLE_SET_TCCL) {
            return Boolean.FALSE;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader previousTCCL = currentThread.getContextClassLoader();
        if (previousTCCL != (contextFinder = this.container.getContextFinder())) {
            currentThread.setContextClassLoader(this.container.getContextFinder());
            return previousTCCL;
        }
        return Boolean.FALSE;
    }

    protected void stop() throws BundleException {
        try {
            final BundleActivator bundleActivator = this.activator;
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (bundleActivator != null) {
                        Object previousTCCL = BundleContextImpl.this.setContextFinder();
                        try {
                            bundleActivator.stop((BundleContext)BundleContextImpl.this);
                        }
                        finally {
                            if (previousTCCL != Boolean.FALSE) {
                                Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (this.debug.DEBUG_GENERAL) {
                Debug.printStackTrace(t2);
            }
            String clazz = this.activator == null ? "" : this.activator.getClass().getName();
            throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, (Throwable)t2);
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServiceRegistrationImpl<?>, ServiceUse<?>> getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provisionServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        EquinoxBundle tmpBundle = this.bundle;
        Object previousTCCL = this.setContextFinder();
        try {
            if (!this.isValid()) return;
            switch (action) {
                case 1: 
                case 2: {
                    BundleListener listener = (BundleListener)l;
                    if (this.debug.DEBUG_EVENTS) {
                        String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
                        Debug.println("dispatchBundleEvent[" + tmpBundle + "](" + listenerName + ")");
                    }
                    listener.bundleChanged((BundleEvent)object);
                    return;
                }
                case 3: {
                    ServiceEvent event = (ServiceEvent)object;
                    ServiceListener listener = (ServiceListener)l;
                    if (this.debug.DEBUG_EVENTS) {
                        String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
                        Debug.println("dispatchServiceEvent[" + tmpBundle + "](" + listenerName + ")");
                    }
                    listener.serviceChanged(event);
                    return;
                }
                case 4: {
                    FrameworkListener listener = (FrameworkListener)l;
                    if (this.debug.DEBUG_EVENTS) {
                        String listenerName = listener.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(listener));
                        Debug.println("dispatchFrameworkEvent[" + tmpBundle + "](" + listenerName + ")");
                    }
                    listener.frameworkEvent((FrameworkEvent)object);
                    return;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        catch (Throwable t) {
            FrameworkEvent event;
            if (this.debug.DEBUG_GENERAL) {
                Debug.println("Exception in bottom level event dispatcher: " + t.getMessage());
                Debug.printStackTrace(t);
            }
            this.container.handleRuntimeError(t);
            if (action == 4 && (event = (FrameworkEvent)object).getType() == 2) {
                return;
            } else {
                this.container.getEventPublisher().publishFrameworkEvent(2, tmpBundle, t);
            }
            return;
        }
        finally {
            if (previousTCCL != Boolean.FALSE) {
                Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
            }
        }
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValid();
        return FilterImpl.newInstance(filter, this.container.getConfiguration().getDebug().DEBUG_FILTER);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration<?> registration = this.registerService(clazz.getName(), service, properties);
        return registration;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        ServiceRegistration<?> registration = this.registerService(clazz.getName(), factory, properties);
        return registration;
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference<?> reference = this.getServiceReference(clazz.getName());
        return reference;
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference<?>[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            List<ServiceReference<S>> empty = Collections.emptyList();
            return empty;
        }
        ArrayList<ServiceReference<S>> result = new ArrayList<ServiceReference<S>>(refs.length);
        for (ServiceReference<?> b : refs) {
            result.add(b);
        }
        return result;
    }

    public EquinoxContainer getContainer() {
        return this.container;
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        this.provisionServicesInUseMap();
        ServiceObjectsImpl serviceObjects = this.container.getServiceRegistry().getServiceObjects(this, (ServiceReferenceImpl)reference);
        return serviceObjects;
    }
}

