/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction<List<ClassLoader>> {
    private static ThreadLocal<Set<String>> cycleDetector = new ThreadLocal();
    static ClassLoader finderClassLoader;
    static Finder contextFinder;
    private static Class<ContextFinder> THIS;
    private final ClassLoader parentContextClassLoader;

    public ContextFinder(ClassLoader contextClassLoader) {
        super(contextClassLoader);
        this.parentContextClassLoader = contextClassLoader != null ? contextClassLoader : new ClassLoader(Object.class.getClassLoader()){};
    }

    List<ClassLoader> basicFindClassLoaders() {
        Class<?>[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        ClassLoader previousLoader = null;
        for (int i = 1; i < stack.length; ++i) {
            ClassLoader tmp = stack[i].getClassLoader();
            if (stack[i] == THIS || tmp == null || tmp == this) continue;
            if (this.checkClassLoader(tmp) && previousLoader != tmp) {
                result.add(tmp);
                previousLoader = tmp;
            }
            if (tmp == finderClassLoader || tmp instanceof ModuleClassLoader) break;
        }
        return result;
    }

    private boolean checkClassLoader(ClassLoader classloader) {
        if (classloader == null || classloader == this.getParent()) {
            return false;
        }
        for (ClassLoader parent = classloader.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            return false;
        }
        return true;
    }

    private List<ClassLoader> findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return AccessController.doPrivileged(this);
    }

    @Override
    public List<ClassLoader> run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        Set<String> classesAndResources = cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        cycleDetector.get().remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            List<ClassLoader> toConsult = this.findClassLoaders();
            Iterator<ClassLoader> loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                try {
                    Class<?> clazz = loaders.next().loadClass(arg0);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                }
            }
            Class<?> clazz = this.parentContextClassLoader.loadClass(arg0);
            return clazz;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String arg0) {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            List<ClassLoader> toConsult = this.findClassLoaders();
            Iterator<ClassLoader> loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                URL result = loaders.next().getResource(arg0);
                if (result == null) continue;
                URL uRL = result;
                return uRL;
            }
            URL uRL = super.getResource(arg0);
            return uRL;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Enumeration<URL> findResources(String arg0) throws IOException {
        if (!this.startLoading(arg0)) {
            Enumeration<URL> result = Collections.enumeration(Collections.EMPTY_LIST);
            return result;
        }
        try {
            List<ClassLoader> toConsult = this.findClassLoaders();
            Iterator<ClassLoader> loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                Enumeration<URL> result = loaders.next().getResources(arg0);
                if (result == null || !result.hasMoreElements()) continue;
                Enumeration<URL> enumeration = result;
                return enumeration;
            }
            Enumeration<URL> enumeration = super.findResources(arg0);
            return enumeration;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                finderClassLoader = ContextFinder.class.getClassLoader();
                contextFinder = new Finder();
                return null;
            }
        });
        THIS = ContextFinder.class;
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

