/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.serviceregistry.HookContext;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;

public class EquinoxEventPublisher {
    static final String eventHookName = EventHook.class.getName();
    static final String collisionHookName = CollisionHook.class.getName();
    static final int BUNDLEEVENT = 1;
    static final int BUNDLEEVENTSYNC = 2;
    static final int FRAMEWORKEVENT = 4;
    private final EquinoxContainer container;
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> allBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>>();
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> allSyncBundleListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>>();
    private final Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> allFrameworkListeners = new HashMap<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>>();

    public EquinoxEventPublisher(EquinoxContainer container) {
        this.container = container;
    }

    public void publishBundleEvent(int type, Bundle bundle, Bundle origin) {
        if (origin != null) {
            this.publishBundleEvent(new BundleEvent(type, bundle, origin));
        } else {
            this.publishBundleEvent(new BundleEvent(type, bundle));
        }
    }

    private void publishBundleEvent(final BundleEvent event) {
        if (System.getSecurityManager() == null) {
            this.publishBundleEventPrivileged(event);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    EquinoxEventPublisher.this.publishBundleEventPrivileged(event);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishBundleEventPrivileged(BundleEvent event) {
        Set listeners;
        EventDispatcher dispatcher;
        ListenerQueue queue;
        HashMap listenersSync;
        BundleContextImpl systemContext = null;
        Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>> systemBundleListenersSync = null;
        Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
        synchronized (map) {
            listenersSync = new HashMap(this.allSyncBundleListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry : this.allSyncBundleListeners.entrySet()) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> listeners2 = entry.getValue();
                if (listeners2.isEmpty()) continue;
                Set<Map.Entry<SynchronousBundleListener, SynchronousBundleListener>> listenerEntries = listeners2.entrySet();
                if (entry.getKey().getBundleImpl().getBundleId() == 0L) {
                    systemContext = (BundleContextImpl)entry.getKey();
                    systemBundleListenersSync = listenerEntries;
                }
                listenersSync.put(entry.getKey(), listeners2.entrySet());
            }
        }
        HashMap<BundleContextImpl, Set<Map.Entry<BundleListener, BundleListener>>> listenersAsync = null;
        Set<Map.Entry<BundleListener, BundleListener>> systemBundleListenersAsync = null;
        if ((event.getType() & 0x380) == 0) {
            Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> entry;
            entry = this.allBundleListeners;
            synchronized (entry) {
                listenersAsync = new HashMap<BundleContextImpl, Set<Map.Entry<BundleListener, BundleListener>>>(this.allBundleListeners.size());
                for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> entry2 : this.allBundleListeners.entrySet()) {
                    CopyOnWriteIdentityMap<BundleListener, BundleListener> listeners3 = entry2.getValue();
                    if (listeners3.isEmpty()) continue;
                    Set<Map.Entry<BundleListener, BundleListener>> listenerEntries = listeners3.entrySet();
                    if (entry2.getKey().getBundleImpl().getBundleId() == 0L) {
                        systemContext = entry2.getKey();
                        systemBundleListenersAsync = listenerEntries;
                    }
                    listenersAsync.put(entry2.getKey(), listenerEntries);
                }
            }
        }
        Collection<BundleContext> shrinkable = listenersAsync == null ? EquinoxEventPublisher.asBundleContexts(listenersSync.keySet()) : new ShrinkableCollection<BundleContext>(EquinoxEventPublisher.asBundleContexts(listenersSync.keySet()), EquinoxEventPublisher.asBundleContexts(listenersAsync.keySet()));
        this.notifyEventHooksPrivileged(event, shrinkable);
        if (systemBundleListenersSync != null && !listenersSync.containsKey(systemContext)) {
            listenersSync.put(systemContext, systemBundleListenersSync);
        }
        if (systemBundleListenersAsync != null && !listenersAsync.containsKey(systemContext)) {
            listenersAsync.put(systemContext, systemBundleListenersAsync);
        }
        if (!listenersSync.isEmpty()) {
            queue = this.container.newListenerQueue();
            for (Map.Entry entry : listenersSync.entrySet()) {
                dispatcher = (EventDispatcher)entry.getKey();
                listeners = (Set)entry.getValue();
                queue.queueListeners(listeners, dispatcher);
            }
            queue.dispatchEventSynchronous(2, event);
        }
        if (listenersAsync != null && !listenersAsync.isEmpty()) {
            queue = this.container.newListenerQueue();
            for (Map.Entry entry : listenersAsync.entrySet()) {
                dispatcher = (EventDispatcher)entry.getKey();
                listeners = (Set)entry.getValue();
                queue.queueListeners(listeners, dispatcher);
            }
            queue.dispatchEventAsynchronous(1, event);
        }
    }

    private void notifyEventHooksPrivileged(final BundleEvent event, final Collection<BundleContext> result) {
        if (this.container.getConfiguration().getDebug().DEBUG_HOOKS) {
            Debug.println("notifyBundleEventHooks(" + event.getType() + ":" + event.getBundle() + ", " + result + " )");
        }
        this.container.getServiceRegistry().notifyHooksPrivileged(new HookContext(){

            @Override
            public void call(Object hook, ServiceRegistration<?> hookRegistration) throws Exception {
                if (hook instanceof EventHook) {
                    ((EventHook)hook).event(event, result);
                }
            }

            @Override
            public String getHookClassName() {
                return eventHookName;
            }

            @Override
            public String getHookMethodName() {
                return "event";
            }
        });
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable) {
        this.publishFrameworkEvent(type, bundle, throwable, null);
    }

    public void publishFrameworkEvent(int type, Bundle bundle, Throwable throwable, final FrameworkListener ... listeners) {
        if (bundle == null) {
            bundle = this.container.getStorage().getModuleContainer().getModule(0L).getBundle();
        }
        final FrameworkEvent event = new FrameworkEvent(type, bundle, throwable);
        if (System.getSecurityManager() == null) {
            this.publishFrameworkEventPrivileged(event, listeners);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    EquinoxEventPublisher.this.publishFrameworkEventPrivileged(event, listeners);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFrameworkEventPrivileged(FrameworkEvent event, FrameworkListener ... callerListeners) {
        HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>> listenerSnapshot;
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            listenerSnapshot = new HashMap<BundleContextImpl, Set<Map.Entry<FrameworkListener, FrameworkListener>>>(this.allFrameworkListeners.size());
            for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> entry : this.allFrameworkListeners.entrySet()) {
                CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> listeners = entry.getValue();
                if (listeners.isEmpty()) continue;
                listenerSnapshot.put(entry.getKey(), listeners.entrySet());
            }
        }
        ListenerQueue<Object, Object, Object> queue = this.container.newListenerQueue();
        if (callerListeners != null && callerListeners.length > 0) {
            HashMap<FrameworkListener, FrameworkListener> listeners = new HashMap<FrameworkListener, FrameworkListener>();
            for (FrameworkListener listener : callerListeners) {
                if (listener == null) continue;
                listeners.put(listener, listener);
            }
            if (listeners.size() > 0) {
                BundleContextImpl bundleContextImpl;
                BundleContextImpl dispatcher = bundleContextImpl = (BundleContextImpl)this.container.getStorage().getModuleContainer().getModule(0L).getBundle().getBundleContext();
                queue.queueListeners(listeners.entrySet(), dispatcher);
            }
        }
        for (Map.Entry<BundleContextImpl, CopyOnWriteIdentityMap<Object, Object>> entry : listenerSnapshot.entrySet()) {
            EventDispatcher dispatcher = entry.getKey();
            Set listeners = (Set)((Object)entry.getValue());
            queue.queueListeners(listeners, dispatcher);
        }
        queue.dispatchEventAsynchronous(4, event);
    }

    public static Collection<BundleContext> asBundleContexts(Collection<? extends BundleContext> c) {
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(BundleListener listener, BundleContextImpl context) {
        if (listener instanceof SynchronousBundleListener) {
            this.container.checkAdminPermission(context.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<Object, Object> listeners = this.allSyncBundleListeners.get(context);
                if (listeners == null) {
                    listeners = new CopyOnWriteIdentityMap();
                    this.allSyncBundleListeners.put(context, listeners);
                }
                listeners.put((SynchronousBundleListener)listener, (SynchronousBundleListener)listener);
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<Object, Object> listeners = this.allBundleListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.allBundleListeners.put(context, listeners);
            }
            listeners.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(BundleListener listener, BundleContextImpl context) {
        if (listener instanceof SynchronousBundleListener) {
            this.container.checkAdminPermission(context.getBundle(), "listener");
            Map<BundleContextImpl, CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener>> map = this.allSyncBundleListeners;
            synchronized (map) {
                CopyOnWriteIdentityMap<SynchronousBundleListener, SynchronousBundleListener> listeners = this.allSyncBundleListeners.get(context);
                if (listeners != null) {
                    listeners.remove(listener);
                }
            }
        }
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<BundleListener, BundleListener> listeners = this.allBundleListeners.get(context);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(FrameworkListener listener, BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<Object, Object> listeners = this.allFrameworkListeners.get(context);
            if (listeners == null) {
                listeners = new CopyOnWriteIdentityMap();
                this.allFrameworkListeners.put(context, listeners);
            }
            listeners.put(listener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(FrameworkListener listener, BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener>> map = this.allFrameworkListeners;
        synchronized (map) {
            CopyOnWriteIdentityMap<FrameworkListener, FrameworkListener> listeners = this.allFrameworkListeners.get(context);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners(BundleContextImpl context) {
        Map<BundleContextImpl, CopyOnWriteIdentityMap<BundleListener, BundleListener>> map = this.allBundleListeners;
        synchronized (map) {
            this.allBundleListeners.remove(context);
        }
        map = this.allSyncBundleListeners;
        synchronized (map) {
            this.allSyncBundleListeners.remove(context);
        }
        map = this.allFrameworkListeners;
        synchronized (map) {
            this.allFrameworkListeners.remove(context);
        }
    }
}

