/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework.legacy;

import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelImpl
implements StartLevel {
    private final ModuleContainer container;

    public StartLevelImpl(ModuleContainer container) {
        this.container = container;
    }

    public int getStartLevel() {
        return this.container.getFrameworkStartLevel().getStartLevel();
    }

    public void setStartLevel(int startlevel) {
        this.container.getFrameworkStartLevel().setStartLevel(startlevel, new FrameworkListener[0]);
    }

    public int getBundleStartLevel(Bundle bundle) {
        return StartLevelImpl.getModule(bundle).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, int startlevel) {
        StartLevelImpl.getModule(bundle).setStartLevel(startlevel);
    }

    public int getInitialBundleStartLevel() {
        return this.container.getFrameworkStartLevel().getInitialBundleStartLevel();
    }

    public void setInitialBundleStartLevel(int startlevel) {
        this.container.getFrameworkStartLevel().setInitialBundleStartLevel(startlevel);
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        return StartLevelImpl.getModule(bundle).isPersistentlyStarted();
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        return StartLevelImpl.getModule(bundle).isActivationPolicyUsed();
    }

    static Module getModule(Bundle bundle) {
        if (bundle instanceof EquinoxBundle) {
            return ((EquinoxBundle)bundle).getModule();
        }
        throw new IllegalArgumentException("Bundle is not from an equinox framework: " + bundle.getClass());
    }
}

