/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.buddy.DependentPolicy;

public class RegisteredPolicy
extends DependentPolicy {
    public RegisteredPolicy(BundleLoader requester) {
        super(requester);
        if (this.allDependents == null) {
            return;
        }
        String requesterName = requester.getWiring().getRevision().getSymbolicName();
        Iterator iter = this.allDependents.iterator();
        while (iter.hasNext()) {
            ModuleWiring wiring = (ModuleWiring)iter.next();
            List<ModuleCapability> moduleDatas = wiring.getRevision().getModuleCapabilities("equinox.module.data");
            List registeredList = (List)(moduleDatas.isEmpty() ? null : moduleDatas.get(0).getAttributes().get("buddy.registered"));
            if (registeredList == null || registeredList.isEmpty()) {
                iter.remove();
                continue;
            }
            boolean contributes = false;
            for (String registeredName : registeredList) {
                if (!registeredName.equals(requesterName)) continue;
                contributes = true;
                break;
            }
            if (contributes) continue;
            iter.remove();
        }
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    @Override
    public Class<?> loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class<?> result = null;
        int size = this.allDependents.size();
        for (int i = 0; i < size && result == null; ++i) {
            ModuleWiring searchWiring = (ModuleWiring)this.allDependents.get(i);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader == null) continue;
            try {
                result = searchLoader.findClass(name);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        int size = this.allDependents.size();
        for (int i = 0; i < size && result == null; ++i) {
            ModuleWiring searchWiring = (ModuleWiring)this.allDependents.get(i);
            BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
            if (searchLoader == null) continue;
            result = searchLoader.findResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration<URL> results = null;
        int size = this.allDependents.size();
        for (int i = 0; i < size; ++i) {
            try {
                ModuleWiring searchWiring = (ModuleWiring)this.allDependents.get(i);
                BundleLoader searchLoader = (BundleLoader)searchWiring.getModuleLoader();
                if (searchLoader == null) continue;
                results = BundleLoader.compoundEnumerations(results, searchLoader.findResources(name));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return results;
    }
}

