/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.SynchronousLogListener;
import org.eclipse.osgi.framework.util.ArrayMap;
import org.eclipse.osgi.internal.log.BasicReadWriteLock;
import org.eclipse.osgi.internal.log.ExtendedLogEntryImpl;
import org.eclipse.osgi.internal.log.ExtendedLogReaderServiceImpl;
import org.eclipse.osgi.internal.log.SerializedTaskQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class ExtendedLogReaderServiceFactory
implements ServiceFactory<ExtendedLogReaderServiceImpl> {
    static final int MAX_RECURSIONS = 50;
    private static final Enumeration<?> EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
    static final LogFilter NULL_LOGGER_FILTER = new LogFilter(){

        @Override
        public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
            return true;
        }
    };
    private static final LogFilter[] ALWAYS_LOG = new LogFilter[0];
    private static PrintStream errorStream;
    private final BasicReadWriteLock listenersLock = new BasicReadWriteLock();
    private ArrayMap<LogListener, Object[]> listeners = new ArrayMap(5);
    private LogFilter[] filters = null;
    private final ThreadLocal<int[]> nestedCallCount = new ThreadLocal();
    private final LinkedList<LogEntry> history;
    private final int maxHistory;

    static boolean safeIsLoggable(LogFilter filter, Bundle bundle, String name, int level) {
        try {
            return filter.isLoggable(bundle, name, level);
        }
        catch (RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogFilter.isLoggable threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        return false;
    }

    private static synchronized PrintStream getErrorStream() {
        if (errorStream == null) {
            return System.err;
        }
        return errorStream;
    }

    public static synchronized void setErrorStream(PrintStream ps) {
        errorStream = ps;
    }

    static void safeLogged(LogListener listener, LogEntry logEntry) {
        try {
            listener.logged(logEntry);
        }
        catch (RuntimeException e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
        catch (LinkageError e) {
            ExtendedLogReaderServiceFactory.getErrorStream().println("LogListener.logged threw a non-fatal unchecked exception as follows:");
            e.printStackTrace(ExtendedLogReaderServiceFactory.getErrorStream());
        }
    }

    public ExtendedLogReaderServiceFactory(int maxHistory) {
        this.maxHistory = maxHistory;
        this.history = maxHistory > 0 ? new LinkedList() : null;
    }

    public ExtendedLogReaderServiceImpl getService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> registration) {
        return new ExtendedLogReaderServiceImpl(this);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<ExtendedLogReaderServiceImpl> registration, ExtendedLogReaderServiceImpl service) {
        service.shutdown();
    }

    boolean isLoggable(final Bundle bundle, final String name, final int level) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ExtendedLogReaderServiceFactory.this.isLoggablePrivileged(bundle, name, level);
                }
            });
        }
        return this.isLoggablePrivileged(bundle, name, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggablePrivileged(Bundle bundle, String name, int level) {
        LogFilter[] filtersCopy;
        this.listenersLock.readLock();
        try {
            filtersCopy = this.filters;
        }
        finally {
            this.listenersLock.readUnlock();
        }
        try {
            if (this.incrementNestedCount() == 50) {
                boolean bl = false;
                return bl;
            }
            if (filtersCopy == null) {
                boolean bl = false;
                return bl;
            }
            if (filtersCopy == ALWAYS_LOG) {
                boolean bl = true;
                return bl;
            }
            for (LogFilter filter : filtersCopy) {
                if (!ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.decrementNestedCount();
        }
        return false;
    }

    private int incrementNestedCount() {
        int[] count = this.getCount();
        count[0] = count[0] + 1;
        return count[0];
    }

    private void decrementNestedCount() {
        int[] count = this.getCount();
        if (count[0] == 0) {
            return;
        }
        count[0] = count[0] - 1;
    }

    private int[] getCount() {
        int[] count = this.nestedCallCount.get();
        if (count == null) {
            count = new int[]{0};
            this.nestedCallCount.set(count);
        }
        return count;
    }

    void log(final Bundle bundle, final String name, final Object context, final int level, final String message, final Throwable exception) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExtendedLogReaderServiceFactory.this.logPrivileged(bundle, name, context, level, message, exception);
                    return null;
                }
            });
        } else {
            this.logPrivileged(bundle, name, context, level, message, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logPrivileged(Bundle bundle, String name, Object context, int level, String message, Throwable exception) {
        ArrayMap<LogListener, Object[]> listenersCopy;
        ExtendedLogEntryImpl logEntry = new ExtendedLogEntryImpl(bundle, name, context, level, message, exception);
        this.storeEntry(logEntry);
        this.listenersLock.readLock();
        try {
            listenersCopy = this.listeners;
        }
        finally {
            this.listenersLock.readUnlock();
        }
        try {
            if (this.incrementNestedCount() >= 50) {
                return;
            }
            int size = listenersCopy.size();
            for (int i = 0; i < size; ++i) {
                Object[] listenerObjects = listenersCopy.getValue(i);
                LogFilter filter = (LogFilter)listenerObjects[0];
                if (!ExtendedLogReaderServiceFactory.safeIsLoggable(filter, bundle, name, level)) continue;
                LogListener listener = listenersCopy.getKey(i);
                SerializedTaskQueue taskQueue = (SerializedTaskQueue)listenerObjects[1];
                if (taskQueue != null) {
                    taskQueue.put(new LogTask(logEntry, listener));
                    continue;
                }
                ExtendedLogReaderServiceFactory.safeLogged(listener, logEntry);
            }
        }
        finally {
            this.decrementNestedCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntry(LogEntry logEntry) {
        if (this.history != null) {
            LinkedList<LogEntry> linkedList = this.history;
            synchronized (linkedList) {
                if (this.history.size() == this.maxHistory) {
                    this.history.removeFirst();
                }
                this.history.addLast(logEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLogListener(LogListener listener, LogFilter filter) {
        this.listenersLock.writeLock();
        try {
            ArrayMap<LogListener, Object[]> listenersCopy = new ArrayMap<LogListener, Object[]>(this.listeners.getKeys(), this.listeners.getValues());
            Object[] listenerObjects = listenersCopy.get(listener);
            if (listenerObjects == null) {
                SerializedTaskQueue taskQueue = listener instanceof SynchronousLogListener ? null : new SerializedTaskQueue(listener.toString());
                listenerObjects = new Object[]{filter, taskQueue};
            } else if (filter != listenerObjects[0]) {
                listenerObjects[0] = filter;
            }
            listenersCopy.put(listener, listenerObjects);
            this.recalculateFilters(listenersCopy);
            this.listeners = listenersCopy;
        }
        finally {
            this.listenersLock.writeUnlock();
        }
    }

    private void recalculateFilters(ArrayMap<LogListener, Object[]> listenersCopy) {
        ArrayList<LogFilter> filtersList = new ArrayList<LogFilter>();
        int size = listenersCopy.size();
        for (int i = 0; i < size; ++i) {
            Object[] listenerObjects = listenersCopy.getValue(i);
            LogFilter filter = (LogFilter)listenerObjects[0];
            if (filter == NULL_LOGGER_FILTER) {
                this.filters = ALWAYS_LOG;
                return;
            }
            filtersList.add(filter);
        }
        if (filtersList.isEmpty()) {
            this.filters = null;
        }
        this.filters = filtersList.toArray(new LogFilter[filtersList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLogListener(LogListener listener) {
        this.listenersLock.writeLock();
        try {
            ArrayMap<LogListener, Object[]> listenersCopy = new ArrayMap<LogListener, Object[]>(this.listeners.getKeys(), this.listeners.getValues());
            listenersCopy.remove(listener);
            this.recalculateFilters(listenersCopy);
            this.listeners = listenersCopy;
        }
        finally {
            this.listenersLock.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration<?> getLog() {
        if (this.history == null) {
            return EMPTY_ENUMERATION;
        }
        LinkedList<LogEntry> linkedList = this.history;
        synchronized (linkedList) {
            return Collections.enumeration(new ArrayList<LogEntry>(this.history));
        }
    }

    static final class LogTask
    implements Runnable {
        private final LogEntry logEntry;
        private final LogListener listener;

        LogTask(LogEntry logEntry, LogListener listener) {
            this.logEntry = logEntry;
            this.listener = listener;
        }

        @Override
        public void run() {
            ExtendedLogReaderServiceFactory.safeLogged(this.listener, this.logEntry);
        }
    }
}

