/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.osgi.service.condpermadmin.Condition;

public class EquinoxSecurityManager
extends SecurityManager {
    private final ThreadLocal<CheckContext> localCheckContext = new ThreadLocal();

    boolean addConditionsForDomain(SecurityRow.Decision[] results) {
        CheckContext cc = this.localCheckContext.get();
        if (cc == null) {
            return false;
        }
        List<SecurityRow.Decision[]> condSets = cc.depthCondSets.get(cc.getDepth());
        if (condSets == null) {
            condSets = new ArrayList<SecurityRow.Decision[]>(1);
            cc.depthCondSets.set(cc.getDepth(), condSets);
        }
        condSets.add(results);
        return true;
    }

    boolean inCheckPermission() {
        return this.localCheckContext.get() != null;
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        AccessController.doPrivileged(new CheckPermissionAction(this, perm, context));
    }

    public AccessControlContext getContextToBeChecked() {
        CheckContext cc = this.localCheckContext.get();
        if (cc != null && cc.accs != null && !cc.accs.isEmpty()) {
            return cc.accs.get(cc.accs.size() - 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalCheckPermission(Permission perm, Object context) {
        AccessControlContext acc = (AccessControlContext)context;
        CheckContext cc = this.localCheckContext.get();
        if (cc == null) {
            cc = new CheckContext();
            this.localCheckContext.set(cc);
        }
        cc.depthCondSets.add(null);
        cc.accs.add(acc);
        try {
            acc.checkPermission(perm);
            List<SecurityRow.Decision[]> conditionSets = cc.depthCondSets.get(cc.getDepth());
            if (conditionSets == null) {
                return;
            }
            HashMap<Class<? extends Condition>, Dictionary<Object, Object>> conditionDictionaries = new HashMap<Class<? extends Condition>, Dictionary<Object, Object>>();
            for (SecurityRow.Decision[] domainDecisions : conditionSets) {
                boolean grant = false;
                for (int i = 0; i < domainDecisions.length && domainDecisions[i] != null; ++i) {
                    if ((domainDecisions[i].decision & 4) != 0) continue;
                    if ((domainDecisions[i].decision & 8) == 0) {
                        if ((domainDecisions[i].decision & 1) == 0) break;
                        grant = true;
                        break;
                    }
                    int decision = this.getPostponedDecision(domainDecisions[i], conditionDictionaries, cc);
                    if ((decision & 4) != 0) continue;
                    if ((decision & 1) == 0) break;
                    grant = true;
                    break;
                }
                if (grant) continue;
                throw new SecurityException("Conditions not satisfied");
            }
        }
        finally {
            cc.depthCondSets.remove(cc.getDepth());
            cc.accs.remove(cc.accs.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPostponedDecision(SecurityRow.Decision decision, Map<Class<? extends Condition>, Dictionary<Object, Object>> conditionDictionaries, CheckContext cc) {
        Condition[] postponed = decision.postponed;
        for (int i = 0; i < postponed.length; ++i) {
            Dictionary<Object, Object> condContext = conditionDictionaries.get(postponed[i].getClass());
            if (condContext == null) {
                condContext = new Hashtable<Object, Object>();
                conditionDictionaries.put(postponed[i].getClass(), condContext);
            }
            if (cc.CondClassSet == null) {
                cc.CondClassSet = new ArrayList(2);
            }
            if (cc.CondClassSet.contains(postponed[i].getClass())) {
                return 4;
            }
            cc.CondClassSet.add(postponed[i].getClass());
            try {
                boolean mutable = postponed[i].isMutable();
                boolean isSatisfied = postponed[i].isSatisfied(new Condition[]{postponed[i]}, condContext);
                decision.handleImmutable(postponed[i], isSatisfied, mutable);
                if (isSatisfied) continue;
                int n = 4;
                return n;
            }
            finally {
                cc.CondClassSet.remove(postponed[i].getClass());
            }
        }
        return decision.decision;
    }

    @Override
    public void checkPermission(Permission perm) {
        this.checkPermission(perm, this.getSecurityContext());
    }

    @Override
    public Object getSecurityContext() {
        return AccessController.getContext();
    }

    static {
        Class c = CheckPermissionAction.class;
        c = CheckContext.class;
        c.getName();
    }

    static class CheckPermissionAction
    implements PrivilegedAction<Void> {
        Permission perm;
        Object context;
        EquinoxSecurityManager fsm;

        CheckPermissionAction(EquinoxSecurityManager fsm, Permission perm, Object context) {
            this.fsm = fsm;
            this.perm = perm;
            this.context = context;
        }

        @Override
        public Void run() {
            this.fsm.internalCheckPermission(this.perm, this.context);
            return null;
        }
    }

    static class CheckContext {
        List<List<SecurityRow.Decision[]>> depthCondSets = new ArrayList<List<SecurityRow.Decision[]>>(2);
        List<AccessControlContext> accs = new ArrayList<AccessControlContext>(2);
        List<Class<?>> CondClassSet;

        CheckContext() {
        }

        public int getDepth() {
            return this.depthCondSets.size() - 1;
        }
    }
}

