/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.provisional.service.security;

import java.util.HashMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> dispatcher = new AuthEventDispatcher();
    private final ServiceTracker<AuthorizationListener, AuthorizationListener> listenerTracker;

    public AuthorizationEngine(BundleContext context) {
        this.listenerTracker = new ServiceTracker(context, AuthorizationListener.class.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent content, Object context) {
        this.fireEvent(this.doAuthorize(content, context));
    }

    private void fireEvent(AuthorizationEvent event) {
        if (event == null) {
            return;
        }
        Object[] services = this.listenerTracker.getServices();
        if (services == null) {
            return;
        }
        HashMap<AuthorizationListener, Object> listeners = new HashMap<AuthorizationListener, Object>();
        for (Object service : services) {
            listeners.put((AuthorizationListener)service, service);
        }
        ListenerQueue<AuthorizationListener, Object, AuthorizationEvent> queue = new ListenerQueue<AuthorizationListener, Object, AuthorizationEvent>(this.manager);
        queue.queueListeners(listeners.entrySet(), this.dispatcher);
        queue.dispatchEventSynchronous(0, event);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    class AuthEventDispatcher
    implements EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> {
        AuthEventDispatcher() {
        }

        @Override
        public void dispatchEvent(AuthorizationListener eventListener, Object listenerObject, int eventAction, AuthorizationEvent eventObject) {
            eventListener.authorizationEvent(eventObject);
        }
    }
}

