/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.BundleException;

public class SystemBundleFile
extends BundleFile {
    public SystemBundleFile() {
        super(null);
    }

    @Override
    public File getFile(String path, boolean nativeCode) {
        return null;
    }

    @Override
    public BundleEntry getEntry(String path) {
        if ("META-INF/MANIFEST.MF".equals(path)) {
            return new BundleEntry(){

                @Override
                public InputStream getInputStream() throws IOException {
                    return SystemBundleFile.this.getManifestURL().openStream();
                }

                @Override
                public long getSize() {
                    return 0L;
                }

                @Override
                public String getName() {
                    return "META-INF/MANIFEST.MF";
                }

                @Override
                public long getTime() {
                    return 0L;
                }

                @Override
                public URL getLocalURL() {
                    return SystemBundleFile.this.getManifestURL();
                }

                @Override
                public URL getFileURL() {
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path, boolean recurse) {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public boolean containsDir(String dir) {
        return false;
    }

    URL getManifestURL() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> manifests;
            Enumeration<URL> enumeration = manifests = cl != null ? cl.getResources("META-INF/MANIFEST.MF") : ClassLoader.getSystemResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                URL url = manifests.nextElement();
                try {
                    Headers<String, String> headers = Headers.parseManifest(url.openStream());
                    if (!"true".equals(headers.get("Eclipse-SystemBundle"))) continue;
                    return url;
                }
                catch (BundleException e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

